Quixe=function(){function quixe_prepare(image,all_options){game_image=image;var ls=game_image.slice(0,64);var ix,val;for(ix=0;ix<ls.length;ix++){val=ls[ix].toString(16);if(val.length<2){val="0"+val}ls[ix]=val}game_signature=ls.join("");if(all_options){opt_rethrow_exceptions=all_options.rethrow_exceptions}}function quixe_init(){if(vm_started){Glk.fatal_error("Quixe was inited twice!");return}try{setup_bytestring_table();setup_operandlist_table();setup_vm();execute_loop()}catch(ex){Glk.fatal_error("Quixe init: "+show_exception(ex));if(opt_rethrow_exceptions){throw ex}}}function quixe_resume(){try{done_executing=vm_stopped;execute_loop()}catch(ex){Glk.fatal_error("Quixe run: "+show_exception(ex));if(opt_rethrow_exceptions){throw ex}}}function show_exception(ex){if(typeof(ex)=="string"){return ex}var res=ex.toString();if(ex.message){res=res+" "+ex.message}if(ex.fileName){res=res+" "+ex.fileName}if(ex.lineNumber){res=res+" line:"+ex.lineNumber}if(ex.name){res=res+" "+ex.name}if(ex.number){res=res+" "+ex.number}return res}function qlog(msg){if(window.console&&console.log){console.log(msg)}else{if(window.opera&&opera.postError){opera.postError(msg)}}}function qobjdump(obj,depth){var key,proplist;if(obj instanceof Array){if(depth){depth--}var ls=obj.map(function(v){return qobjdump(v,depth)});return("["+ls.join(",")+"]")}if(!(obj instanceof Object)){return(""+obj)}proplist=[];for(key in obj){var val=obj[key];if(depth&&val instanceof Object){val=qobjdump(val,depth-1)}proplist.push(key+":"+val)}return"{ "+proplist.join(", ")+" }"}var bytestring_table=Array(256);var quotechar_table=Array(256);function setup_bytestring_table(){var ix,val;for(ix=0;ix<256;ix++){val=ix.toString(16);if(ix<16){val="0"+val}bytestring_table[ix]=val}for(ix=0;ix<256;ix++){if(ix>=32&&ix<127){if(ix==34||ix==39||ix==92){val="\\"+String.fromCharCode(ix)}else{val=String.fromCharCode(ix)}}else{if(ix==10){val="\\n"}else{val="\\x"+bytestring_table[ix]}}quotechar_table[ix]=val}}function ByteRead4(arr,addr){return(arr[addr]*16777216)+(arr[addr+1]*65536)+(arr[addr+2]*256)+(arr[addr+3])}function ByteRead2(arr,addr){return(arr[addr]*256)+(arr[addr+1])}function ByteRead1(arr,addr){return arr[addr]}function Mem1(addr){return memmap[addr]}function Mem2(addr){return(memmap[addr]*256)+(memmap[addr+1])}function Mem4(addr){return(memmap[addr]*16777216)+(memmap[addr+1]*65536)+(memmap[addr+2]*256)+(memmap[addr+3])}function MemW1(addr,val){memmap[addr]=val&255}function MemW2(addr,val){memmap[addr]=(val>>8)&255;memmap[addr+1]=val&255}function MemW4(addr,val){memmap[addr]=(val>>24)&255;memmap[addr+1]=(val>>16)&255;memmap[addr+2]=(val>>8)&255;memmap[addr+3]=val&255}function BytePushString(arr,str){for(var ix=0;ix<str.length;ix++){arr.push(str.charCodeAt(ix))}}function BytePush4(arr,val){arr.push((val>>24)&255);arr.push((val>>16)&255);arr.push((val>>8)&255);arr.push(val&255)}function BytePush2(arr,val){arr.push((val>>8)&255);arr.push(val&255)}function BytePush1(arr,val){arr.push(val&255)}function ByteWrite4(arr,addr,val){arr[addr]=(val>>24)&255;arr[addr+1]=(val>>16)&255;arr[addr+2]=(val>>8)&255;arr[addr+3]=val&255}function ByteReadString(arr,addr,len){return String.fromCharCode.apply(this,arr.slice(addr,addr+len))}function QuoteMem1(addr){if(memmap[addr]>=128){return"0xffffff"+bytestring_table[memmap[addr]]}return"0x"+bytestring_table[memmap[addr]]}function QuoteMem2(addr){if(memmap[addr]>=128){return"0xffff"+bytestring_table[memmap[addr]]+bytestring_table[memmap[addr+1]]}if(memmap[addr]){return"0x"+bytestring_table[memmap[addr]]+bytestring_table[memmap[addr+1]]}return"0x"+bytestring_table[memmap[addr+1]]}function QuoteMem4(addr){if(memmap[addr]){return"0x"+bytestring_table[memmap[addr]]+bytestring_table[memmap[addr+1]]+bytestring_table[memmap[addr+2]]+bytestring_table[memmap[addr+3]]}if(memmap[addr+1]){return"0x"+bytestring_table[memmap[addr+1]]+bytestring_table[memmap[addr+2]]+bytestring_table[memmap[addr+3]]}if(memmap[addr+2]){return"0x"+bytestring_table[memmap[addr+2]]+bytestring_table[memmap[addr+3]]}return"0x"+bytestring_table[memmap[addr+3]]}function ReadArgByte(addr){if(addr==4294967295){return frame.valstack.pop()&255}else{return Mem1(addr)}}function WriteArgByte(addr,val){if(addr==4294967295){frame.valstack.push(val&255)}else{MemW1(addr,val)}}function ReadArgWord(addr){if(addr==4294967295){return frame.valstack.pop()}else{return Mem4(addr)}}function WriteArgWord(addr,val){if(addr==4294967295){frame.valstack.push(val)}else{MemW4(addr,val)}}function ReadStructField(addr,fieldnum){if(addr==4294967295){return frame.valstack.pop()}else{return Mem4(addr+4*fieldnum)}}function WriteStructField(addr,fieldnum,val){if(addr==4294967295){frame.valstack.push(val)}else{MemW4(addr+4*fieldnum,val)}}function SetResumeStore(val){resumevalue=val}function CharToString(val){if(val<65536){return String.fromCharCode(val)}else{val-=65536;return String.fromCharCode(55296+(val>>10),56320+(val&1023))}}function QuoteCharToString(val){if(val<256){return quotechar_table[val]}else{if(val<65536){val=val.toString(16);while(val.length<4){val="0"+val}return("\\u"+val)}else{var val2;val-=65536;val2=55296+(val>>10);val=56320+(val&1023);return("\\u"+val2.toString(16)+"\\u"+val.toString(16))}}}function QuoteStr1ToString(val){return QuoteCharToString(val.charCodeAt(0))}var regexp_string_unsafe=/[^a-zA-Z0-9 .,;:?!=_+()-]/g;function QuoteEscapeString(val){val=val.replace(regexp_string_unsafe,QuoteStr1ToString);return'"'+val+'"'}function fatal_error(msg){var ix,val;if(arguments.length>1){msg+=" (";for(ix=1;ix<arguments.length;ix++){val=arguments[ix];if(typeof(val)=="number"){val=val.toString(16)}else{val=""+val}if(ix!=1){msg+=" "}msg+=val}msg+=")"}qlog(msg);throw (msg)}function make_code(val,arg){if(arg===undefined){eval("function _func() {\n"+val+"\n}")}else{eval("function _func("+arg+") {\n"+val+"\n}")}return _func}function VMFunc(funcaddr,startpc,localsformat,rawformat){this.funcaddr=funcaddr;this.startpc=startpc;this.functype=Mem1(funcaddr);this.pathaddrs={};this[0]={};this[1]={};this[2]={};this.locallen=null;this.localsformat=localsformat;this.rawformat=rawformat;this.localsindex=[];var ix,jx;var locallen=0;for(ix=0;ix<this.localsformat.length;ix++){var form=this.localsformat[ix];if(form.size==4){while(locallen&3){locallen++}}else{if(form.size==2){while(locallen&1){locallen++}}}for(jx=0;jx<form.count;jx++){this.localsindex.push({size:form.size,pos:locallen});locallen+=form.size}}while(locallen&3){locallen++}this.locallen=locallen}function StackFrame(vmfunc){var ix;this.vmfunc=vmfunc;this.depth=null;this.framestart=null;this.framelen=null;this.valstack=[];this.localspos=null;this.localsindex=vmfunc.localsindex;this.locals=[];for(ix=0;ix<this.localsindex.length;ix++){var form=this.localsindex[ix];this.locals[form.pos]=0}this.framelen=8+vmfunc.rawformat.length+vmfunc.locallen}function clone_stackframe(frame){var other=new StackFrame(frame.vmfunc);other.depth=frame.depth;other.framestart=frame.framestart;other.framelen=frame.framelen;other.valstack=frame.valstack.slice(0);other.localspos=frame.localspos;other.locals=frame.locals.slice(0);other.framelen=frame.framelen;return other}function push_serialized_stackframe(frame,arr){BytePush4(arr,frame.framelen);var rawformat=frame.vmfunc.rawformat;BytePush4(arr,8+rawformat.length);for(var i=0;i<rawformat.length;i++){arr.push(rawformat[i])}for(var i=0;i<frame.vmfunc.localsindex.length;i++){var form=frame.vmfunc.localsindex[i];if(form.size==4){while(arr.length&3){arr.push(0)}BytePush4(arr,frame.locals[form.pos])}else{if(form.size==2){while(arr.length&1){arr.push(0)}BytePush2(arr,frame.locals[form.pos])}else{BytePush1(arr,frame.locals[form.pos])}}}while(arr.length&3){arr.push(0)}for(var i=0;i<frame.valstack.length;i++){BytePush4(arr,frame.valstack[i])}}function pop_deserialized_stackframe(arr,vmfunc){var frameptr=ByteRead4(arr,arr.length-4);if(frameptr<0||frameptr>=arr.length){qlog("Bad frameptr in serialized stack frame");return undefined}arr=arr.splice(frameptr,arr.length);var framelen=ByteRead4(arr,0);var localspos=ByteRead4(arr,4);if(localspos!=(8+vmfunc.rawformat.length)){qlog("LocalsPos in save file ("+localspos+") doesn't match game image ("+(8+vmfunc.rawformat.length)+")");return undefined}if(framelen!=(localspos+vmfunc.locallen)){qlog("FrameLen in save file ("+framelen+") doesn't match game image ("+(localspos+vmfunc.locallen)+")");return undefined}var frame=new StackFrame(vmfunc);frame.framestart=frameptr;for(var i=0;i<frame.vmfunc.localsindex.length;i++){var form=frame.vmfunc.localsindex[i];if(form.size==4){frame.locals[form.pos]=ByteRead4(arr,4+localspos+form.pos)}else{if(form.size==2){frame.locals[form.pos]=ByteRead2(arr,4+localspos+form.pos)}else{frame.locals[form.pos]=ByteRead1(arr,4+localspos+form.pos)}}}for(var pos=framelen;pos<arr.length;pos+=4){frame.valstack.push(ByteRead4(arr,pos))}return frame}function VMTextEnv(addr,dectab){if(addr==0){fatal_error("Tried to create a VMTextEnv for address zero.")}this.addr=addr;this.cacheable=(dectab!==undefined);this.decoding_tree=dectab;this.vmstring_tables=[];if(this.cacheable){this.vmstring_tables[0]={};this.vmstring_tables[1]={};this.vmstring_tables[2]={}}}var operandlist_table=null;function setup_operandlist_table(){function OperandList(formlist,argsize){this.argsize=(argsize?argsize:4);this.numops=formlist.length;var ls=[];for(var ix=0;ix<formlist.length;ix++){ls.push(formlist.charAt(ix))}this.formlist=ls}var list_none=new OperandList("");var list_L=new OperandList("L");var list_LL=new OperandList("LL");var list_LLL=new OperandList("LLL");var list_LLLL=new OperandList("LLLL");var list_LS=new OperandList("LS");var list_LLS=new OperandList("LLS");var list_LLLLLLS=new OperandList("LLLLLLS");var list_LLLLLLLS=new OperandList("LLLLLLLS");var list_LLSS=new OperandList("LLSS");var list_LC=new OperandList("LC");var list_LLC=new OperandList("LLC");var list_LLLC=new OperandList("LLLC");var list_LLLLC=new OperandList("LLLLC");var list_ES=new OperandList("ES");var list_LES=new OperandList("LES");var list_EES=new OperandList("EES");var list_F=new OperandList("F");var list_LF=new OperandList("LF");var list_LLF=new OperandList("LLF");var list_EF=new OperandList("EF");var list_1EF=new OperandList("EF",1);var list_2EF=new OperandList("EF",2);var list_S=new OperandList("S");var list_SS=new OperandList("SS");var list_CL=new OperandList("CL");var list_C=new OperandList("C");operandlist_table={0:list_none,16:list_EES,17:list_LES,18:list_LLS,19:list_LLS,20:list_LLS,21:list_ES,24:list_EES,25:list_EES,26:list_EES,27:list_ES,28:list_LLS,29:list_LLS,30:list_LLS,32:list_L,34:list_LL,35:list_LL,36:list_LLL,37:list_LLL,38:list_LLL,39:list_LLL,40:list_LLL,41:list_LLL,42:list_LLL,43:list_LLL,44:list_LLL,45:list_LLL,48:list_LLC,49:list_L,50:list_CL,51:list_LL,52:list_LL,64:list_EF,65:list_2EF,66:list_1EF,68:list_LS,69:list_LS,72:list_LLS,73:list_LLS,74:list_LLS,75:list_LLS,76:list_LLL,77:list_LLL,78:list_LLL,79:list_LLL,80:list_F,81:list_LF,82:list_none,83:list_LL,84:list_L,112:list_L,113:list_L,114:list_L,115:list_L,256:list_LLS,257:list_L,258:list_S,259:list_LS,260:list_L,272:list_LS,273:list_L,288:list_none,289:list_S,290:list_none,291:list_LC,292:list_LS,293:list_C,294:list_S,295:list_LL,304:list_LLF,320:list_S,321:list_L,328:list_SS,329:list_LL,336:list_LLLLLLLS,337:list_LLLLLLLS,338:list_LLLLLLS,352:list_LC,353:list_LLC,354:list_LLLC,355:list_LLLLC,368:list_LL,369:list_LLL,376:list_LS,377:list_L,384:list_LL,385:list_LL,400:list_LS,401:list_LS,402:list_LS,408:list_LS,409:list_LS,416:list_LLS,417:list_LLS,418:list_LLS,419:list_LLS,420:list_LLSS,424:list_LS,425:list_LS,426:list_LS,427:list_LLS,432:list_LS,433:list_LS,434:list_LS,435:list_LS,436:list_LS,437:list_LS,438:list_LLS,448:list_LLLL,449:list_LLLL,450:list_LLL,451:list_LLL,452:list_LLL,453:list_LLL,456:list_LL,457:list_LL}}var funcop_cache={};function oputil_record_funcop(funcop){if(funcop.mode==0){return"null"}var key="m"+funcop.mode;if(funcop.argsize!=null){key=key+"s"+funcop.argsize}if(funcop.addr!=null){key=key+"a"+funcop.addr}if(funcop_cache.key){return"funcop_cache."+key}var obj={key:key,mode:funcop.mode,argsize:funcop.argsize,addr:funcop.addr};funcop_cache[key]=obj;return"funcop_cache."+key}function oputil_store(context,funcop,operand){switch(funcop.mode){case 8:if(quot_isconstant(operand)&&funcop.argsize==4){context.offstack.push(operand)}else{holdvar=alloc_holdvar(context,true);context.offstack.push(holdvar);if(funcop.argsize==4){context.code.push(holdvar+"=("+operand+");")}else{if(funcop.argsize==2){context.code.push(holdvar+"=0xffff&("+operand+");")}else{context.code.push(holdvar+"=0xff&("+operand+");")}}}return;case 0:context.code.push("("+operand+");");return;case 11:if(funcop.argsize==4){context.code.push("frame.locals["+funcop.addr+"]=("+operand+");")}else{if(funcop.argsize==2){context.code.push("frame.locals["+funcop.addr+"]=(0xffff &"+operand+");")}else{context.code.push("frame.locals["+funcop.addr+"]=(0xff &"+operand+");")}}return;case 15:if(funcop.argsize==4){context.code.push("MemW4("+funcop.addr+","+operand+");")}else{if(funcop.argsize==2){context.code.push("MemW2("+funcop.addr+","+operand+");")}else{context.code.push("MemW1("+funcop.addr+","+operand+");")}}return;default:fatal_error("Unknown addressing mode in store func operand.")}}function oputil_push_callstub(context,operand,addr){if(addr===undefined){addr=context.cp}context.code.push("frame.valstack.push("+operand+","+addr+",frame.framestart);")}function oputil_push_substring_callstub(context){context.code.push("if (!substring) { substring=true;");context.code.push("frame.valstack.push(0x11,0,nextcp,frame.framestart);");context.code.push("}")}function oputil_unload_offstack(context,keepstack){if(context.offstack.length){context.code.push("frame.valstack.push("+context.offstack.join(",")+");");if(!keepstack){var holdvar;while(context.offstack.length){holdvar=context.offstack.pop();if(context.holduse[holdvar]!==undefined){context.holduse[holdvar]=false}}}}}function oputil_flush_string(context){if(context.buffer.length==0){return}var str=context.buffer.join("");context.buffer.length=0;context.code.push("Glk.glk_put_jstring("+QuoteEscapeString(str)+");")}function oputil_signify_operand(context,operand,hold){var val;if(quot_isconstant(operand)){val=Number(operand);if(val&2147483648){return""+(val-4294967296)}else{return operand}}val="("+operand+"&0xffffffff)";if(hold){var holdvar=alloc_holdvar(context);context.code.push(holdvar+"="+val+";");return holdvar}else{return val}}function oputil_decode_float(context,operand,hold){var val;if(quot_isconstant(operand)){val=Number(operand);if(val==2147483648){return"-0"}return""+decode_float(val)}val="decode_float("+operand+")";if(hold){var holdvar=alloc_holdvar(context);context.code.push(holdvar+"="+val+";");return holdvar}else{return val}}function oputil_perform_jump(context,operand,unconditional){if(quot_isconstant(operand)){var val=Number(operand);if(val==0||val==1){if(unconditional){context.offstack.length=0}else{}context.code.push("leave_function();");context.code.push("pop_callstub("+val+");")}else{oputil_unload_offstack(context,!unconditional);var newpc=(context.cp+val-2)>>>0;context.code.push("pc = "+newpc+";");context.vmfunc.pathaddrs[newpc]=true}}else{oputil_unload_offstack(context,!unconditional);context.code.push("if (("+operand+")==0 || ("+operand+")==1) {");context.code.push("leave_function();");context.code.push("pop_callstub("+operand+");");context.code.push("}");context.code.push("else {");context.code.push("pc = ("+context.cp+"+("+operand+")-2) >>>0;");context.code.push("}")}context.code.push("return;")}var opcode_table={0:function(context,operands){},16:function(context,operands){context.code.push(operands[2]+"(("+operands[0]+")+("+operands[1]+")) >>>0);")},17:function(context,operands){context.code.push(operands[2]+"(("+operands[0]+")-("+operands[1]+")) >>>0);")},18:function(context,operands){var sign0=oputil_signify_operand(context,operands[0]);var sign1=oputil_signify_operand(context,operands[1]);context.code.push(operands[2]+"(("+sign0+")*("+sign1+")) >>>0);")},19:function(context,operands){var sign0=oputil_signify_operand(context,operands[0]);var sign1=oputil_signify_operand(context,operands[1]);var holdvar=alloc_holdvar(context);context.code.push(holdvar+"=(("+sign0+")/("+sign1+"));");context.code.push("if (!isFinite("+holdvar+")) fatal_error('Division by zero.');");context.code.push(operands[2]+"("+holdvar+">=0)?Math.floor("+holdvar+"):(-Math.floor(-"+holdvar+") >>>0));")},20:function(context,operands){var sign0=oputil_signify_operand(context,operands[0]);var sign1=oputil_signify_operand(context,operands[1]);var holdvar=alloc_holdvar(context);context.code.push(holdvar+"=(("+sign0+")%("+sign1+"));");context.code.push("if (!isFinite("+holdvar+")) fatal_error('Modulo division by zero.');");context.code.push(operands[2]+holdvar+" >>>0);")},21:function(context,operands){context.code.push(operands[1]+"(-("+operands[0]+")) >>>0);")},24:function(context,operands){context.code.push(operands[2]+"(("+operands[0]+")&("+operands[1]+")) >>>0);")},25:function(context,operands){context.code.push(operands[2]+"(("+operands[0]+")|("+operands[1]+")) >>>0);")},26:function(context,operands){context.code.push(operands[2]+"(("+operands[0]+")^("+operands[1]+")) >>>0);")},27:function(context,operands){context.code.push(operands[1]+"(~("+operands[0]+")) >>>0);")},28:function(context,operands){if(quot_isconstant(operands[1])){var val=Number(operands[1]);if(val<32){context.code.push(operands[2]+"(("+operands[0]+")<<"+val+") >>>0);")}else{context.code.push(operands[2]+"0);")}}else{context.code.push(operands[2]+"("+operands[1]+"<32) ? (("+operands[0]+"<<"+operands[1]+") >>>0) : 0);")}},29:function(context,operands){if(quot_isconstant(operands[1])){var val=Number(operands[1]);if(val<32){context.code.push(operands[2]+"(("+operands[0]+")>>"+val+") >>>0);")}else{context.code.push(operands[2]+"(("+operands[0]+")&0x80000000) ? 0xffffffff : 0);")}}else{context.code.push("if ("+operands[0]+" & 0x80000000) {");context.code.push(operands[2]+"("+operands[1]+"<32) ? (("+operands[0]+">>"+operands[1]+") >>>0) : 0xffffffff);");context.code.push("} else {");context.code.push(operands[2]+"("+operands[1]+"<32) ? (("+operands[0]+">>"+operands[1]+") >>>0) : 0);");context.code.push("}")}},30:function(context,operands){if(quot_isconstant(operands[1])){var val=Number(operands[1]);if(val<32){context.code.push(operands[2]+"("+operands[0]+")>>>"+val+");")}else{context.code.push(operands[2]+"0);")}}else{context.code.push(operands[2]+"("+operands[1]+"<32) ? ("+operands[0]+">>>"+operands[1]+") : 0);")}},32:function(context,operands){oputil_perform_jump(context,operands[0],true);context.path_ends=true},260:function(context,operands){if(quot_isconstant(operands[0])){var newpc=Number(operands[0]);context.code.push("pc = "+newpc+";");context.vmfunc.pathaddrs[newpc]=true}else{context.code.push("pc = "+operands[0]+";")}oputil_unload_offstack(context);context.code.push("return;");context.path_ends=true},34:function(context,operands){context.code.push("if (("+operands[0]+")==0) {");oputil_perform_jump(context,operands[1]);context.code.push("}")},35:function(context,operands){context.code.push("if (("+operands[0]+")!=0) {");oputil_perform_jump(context,operands[1]);context.code.push("}")},36:function(context,operands){context.code.push("if (("+operands[0]+")==("+operands[1]+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},37:function(context,operands){context.code.push("if (("+operands[0]+")!=("+operands[1]+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},38:function(context,operands){var sign0=oputil_signify_operand(context,operands[0]);var sign1=oputil_signify_operand(context,operands[1]);context.code.push("if (("+sign0+")<("+sign1+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},39:function(context,operands){var sign0=oputil_signify_operand(context,operands[0]);var sign1=oputil_signify_operand(context,operands[1]);context.code.push("if (("+sign0+")>=("+sign1+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},40:function(context,operands){var sign0=oputil_signify_operand(context,operands[0]);var sign1=oputil_signify_operand(context,operands[1]);context.code.push("if (("+sign0+")>("+sign1+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},41:function(context,operands){var sign0=oputil_signify_operand(context,operands[0]);var sign1=oputil_signify_operand(context,operands[1]);context.code.push("if (("+sign0+")<=("+sign1+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},42:function(context,operands){context.code.push("if (("+operands[0]+")<("+operands[1]+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},43:function(context,operands){context.code.push("if (("+operands[0]+")>=("+operands[1]+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},44:function(context,operands){context.code.push("if (("+operands[0]+")>("+operands[1]+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},45:function(context,operands){context.code.push("if (("+operands[0]+")<=("+operands[1]+")) {");oputil_perform_jump(context,operands[2]);context.code.push("}")},48:function(context,operands){if(quot_isconstant(operands[1])){var ix;var argc=Number(operands[1]);for(ix=0;ix<argc;ix++){if(context.offstack.length){var holdvar=pop_offstack_holdvar(context);context.code.push("tempcallargs["+ix+"]="+holdvar+";")}else{context.code.push("tempcallargs["+ix+"]=frame.valstack.pop();")}}oputil_unload_offstack(context)}else{context.varsused.ix=true;oputil_unload_offstack(context);context.code.push("for (ix=0; ix<"+operands[1]+"; ix++) { tempcallargs[ix]=frame.valstack.pop(); }")}oputil_push_callstub(context,operands[2]);context.code.push("enter_function("+operands[0]+", "+operands[1]+");");context.code.push("return;");context.path_ends=true},52:function(context,operands){if(quot_isconstant(operands[1])){var ix;var argc=Number(operands[1]);for(ix=0;ix<argc;ix++){if(context.offstack.length){var holdvar=pop_offstack_holdvar(context);context.code.push("tempcallargs["+ix+"]="+holdvar+";")}else{context.code.push("tempcallargs["+ix+"]=frame.valstack.pop();")}}oputil_unload_offstack(context)}else{context.varsused.ix=true;oputil_unload_offstack(context);context.code.push("for (ix=0; ix<"+operands[1]+"; ix++) { tempcallargs[ix]=frame.valstack.pop(); }")}context.code.push("leave_function();");context.code.push("enter_function("+operands[0]+", "+operands[1]+");");context.code.push("return;");context.path_ends=true},352:function(context,operands){oputil_unload_offstack(context);oputil_push_callstub(context,operands[1]);context.code.push("enter_function("+operands[0]+", 0);");context.code.push("return;");context.path_ends=true},353:function(context,operands){oputil_unload_offstack(context);context.code.push("tempcallargs[0]=("+operands[1]+");");oputil_push_callstub(context,operands[2]);context.code.push("enter_function("+operands[0]+", 1);");context.code.push("return;");context.path_ends=true},354:function(context,operands){oputil_unload_offstack(context);context.code.push("tempcallargs[0]=("+operands[1]+");");context.code.push("tempcallargs[1]=("+operands[2]+");");oputil_push_callstub(context,operands[3]);context.code.push("enter_function("+operands[0]+", 2);");context.code.push("return;");context.path_ends=true},355:function(context,operands){oputil_unload_offstack(context);context.code.push("tempcallargs[0]=("+operands[1]+");");context.code.push("tempcallargs[1]=("+operands[2]+");");context.code.push("tempcallargs[2]=("+operands[3]+");");oputil_push_callstub(context,operands[4]);context.code.push("enter_function("+operands[0]+", 3);");context.code.push("return;");context.path_ends=true},49:function(context,operands){context.offstack.length=0;context.code.push("leave_function();");context.code.push("pop_callstub("+operands[0]+");");context.code.push("return;");context.path_ends=true},50:function(context,operands){oputil_unload_offstack(context);oputil_push_callstub(context,operands[0]);context.code.push("store_operand("+operands[0]+",frame.framestart+frame.framelen+4*frame.valstack.length);");oputil_perform_jump(context,operands[1],true);context.path_ends=true},51:function(context,operands){context.offstack.length=0;context.code.push("pop_stack_to("+operands[1]+");");context.code.push("pop_callstub("+operands[0]+");");context.code.push("return;");context.path_ends=true},64:function(context,operands){oputil_store(context,operands[1],operands[0])},65:function(context,operands){oputil_store(context,operands[1],operands[0])},66:function(context,operands){oputil_store(context,operands[1],operands[0])},68:function(context,operands){var val;if(quot_isconstant(operands[0])){val=Number(operands[0]);val=(val&32768)?((val|4294901760)>>>0):(val&65535);context.code.push(operands[1]+val+");")}else{context.code.push(operands[1]+"("+operands[0]+" & 0x8000) ? (("+operands[0]+" | 0xffff0000) >>> 0) : ("+operands[0]+" & 0xffff));")}},69:function(context,operands){var val;if(quot_isconstant(operands[0])){val=Number(operands[0]);val=(val&128)?((val|4294967040)>>>0):(val&255);context.code.push(operands[1]+val+");")}else{context.code.push(operands[1]+"("+operands[0]+" & 0x80) ? (("+operands[0]+" | 0xffffff00) >>> 0) : ("+operands[0]+" & 0xff));")}},72:function(context,operands){var val,addr;if(quot_isconstant(operands[1])){if(quot_isconstant(operands[0])){addr=Number(operands[0])+Number(operands[1])*4;val="Mem4("+(addr>>>0)+")"}else{var addr=Number(operands[1])*4;if(addr){val="Mem4(("+operands[0]+"+"+addr+") >>>0)"}else{val="Mem4("+operands[0]+")"}}}else{val="Mem4(("+operands[0]+"+4*"+operands[1]+") >>>0)"}context.code.push(operands[2]+val+");")},73:function(context,operands){var val,addr;if(quot_isconstant(operands[1])){if(quot_isconstant(operands[0])){addr=Number(operands[0])+Number(operands[1])*2;val="Mem2("+(addr>>>0)+")"}else{var addr=Number(operands[1])*2;if(addr){val="Mem2(("+operands[0]+"+"+addr+") >>>0)"}else{val="Mem2("+operands[0]+")"}}}else{val="Mem2(("+operands[0]+"+2*"+operands[1]+") >>>0)"}context.code.push(operands[2]+val+");")},74:function(context,operands){var val,addr;if(quot_isconstant(operands[1])){if(quot_isconstant(operands[0])){addr=Number(operands[0])+Number(operands[1]);val="Mem1("+(addr>>>0)+")"}else{var addr=Number(operands[1]);if(addr){val="Mem1(("+operands[0]+"+"+addr+") >>>0)"}else{val="Mem1("+operands[0]+")"}}}else{val="Mem1(("+operands[0]+"+"+operands[1]+") >>>0)"}context.code.push(operands[2]+val+");")},76:function(context,operands){var val,addr;if(quot_isconstant(operands[1])){if(quot_isconstant(operands[0])){addr=Number(operands[0])+Number(operands[1])*4;val=(addr>>>0)+","}else{var addr=Number(operands[1])*4;if(addr){val="("+operands[0]+"+"+addr+") >>>0,"}else{val=operands[0]+","}}}else{val="("+operands[0]+"+4*"+operands[1]+") >>>0,"}context.code.push("MemW4("+val+operands[2]+");")},77:function(context,operands){var val,addr;if(quot_isconstant(operands[1])){if(quot_isconstant(operands[0])){addr=Number(operands[0])+Number(operands[1])*2;val=(addr>>>0)+","}else{var addr=Number(operands[1])*2;if(addr){val="("+operands[0]+"+"+addr+") >>>0,"}else{val=operands[0]+","}}}else{val="("+operands[0]+"+2*"+operands[1]+") >>>0,"}context.code.push("MemW2("+val+operands[2]+");")},78:function(context,operands){var val,addr;if(quot_isconstant(operands[1])){if(quot_isconstant(operands[0])){addr=Number(operands[0])+Number(operands[1]);val=(addr>>>0)+","}else{var addr=Number(operands[1]);if(addr){val="("+operands[0]+"+"+addr+") >>>0,"}else{val=operands[0]+","}}}else{val="("+operands[0]+"+"+operands[1]+") >>>0,"}context.code.push("MemW1("+val+operands[2]+");")},75:function(context,operands){if(quot_isconstant(operands[1])){var bitx,addrx,bitnum;bitnum=Number(operands[1])&4294967295;bitx=bitnum&7;if(quot_isconstant(operands[0])){addrx=Number(operands[0]);if(bitnum>=0){addrx+=(bitnum>>3)}else{addrx-=(1+((-1-bitnum)>>3))}}else{if(bitnum>=0){if(bitnum<=7){addrx=operands[0]}else{addrx=(operands[0]+"+"+(bitnum>>3))}}else{addrx=(operands[0]+"-"+(1+((-1-bitnum)>>3)))}}context.code.push(operands[2]+"(Mem1("+addrx+") & "+(1<<bitx)+")?1:0);")}else{context.varsused.bitx=true;context.varsused.addrx=true;var sign1=oputil_signify_operand(context,operands[1],true);context.code.push("bitx = "+sign1+"&7;");context.code.push("if ("+sign1+">=0) addrx = "+operands[0]+" + ("+sign1+">>3);");context.code.push("else addrx = "+operands[0]+" - (1+((-1-("+sign1+"))>>3));");context.code.push(operands[2]+"(Mem1(addrx) & (1<<bitx))?1:0);")}},79:function(context,operands){var bitx,addrx,mask,bitnum;if(quot_isconstant(operands[1])){bitnum=Number(operands[1])&4294967295;bitx=bitnum&7;if(quot_isconstant(operands[0])){addrx=Number(operands[0]);if(bitnum>=0){addrx+=(bitnum>>3)}else{addrx-=(1+((-1-bitnum)>>3))}}else{if(bitnum>=0){if(bitnum<=7){addrx=operands[0]}else{addrx=(operands[0]+"+"+(bitnum>>3))}}else{addrx=(operands[0]+"-"+(1+((-1-bitnum)>>3)))}}mask=(1<<bitx)}else{context.varsused.bitx=true;context.varsused.addrx=true;var sign1=oputil_signify_operand(context,operands[1],true);context.code.push("bitx = "+sign1+"&7;");context.code.push("if ("+sign1+">=0) addrx = "+operands[0]+" + ("+sign1+">>3);");context.code.push("else addrx = "+operands[0]+" - (1+((-1-("+sign1+"))>>3));");addrx="addrx";mask="(1<<bitx)"}if(quot_isconstant(operands[2])){if(Number(operands[2])){context.code.push("MemW1("+addrx+", Mem1("+addrx+") | "+mask+");")}else{context.code.push("MemW1("+addrx+", Mem1("+addrx+") & ~("+mask+"));")}}else{context.code.push("if ("+operands[2]+") MemW1("+addrx+", Mem1("+addrx+") | "+mask+");");context.code.push("else MemW1("+addrx+", Mem1("+addrx+") & ~("+mask+"));")}},80:function(context,operands){var val;var count=context.offstack.length;if(count){val="frame.valstack.length+"+count}else{val="frame.valstack.length"}oputil_store(context,operands[0],val)},81:function(context,operands){var val;if(quot_isconstant(operands[0])){var pos=Number(operands[0]);if(pos<context.offstack.length){val=context.offstack[context.offstack.length-(pos+1)]}else{val="frame.valstack[frame.valstack.length-"+((pos+1)-context.offstack.length)+"]"}}else{oputil_unload_offstack(context);val="frame.valstack[frame.valstack.length-("+operands[0]+"+1)]"}oputil_store(context,operands[1],val)},82:function(context,operands){var temp,len;if(context.offstack.length<2){transfer_to_offstack(context,2)}len=context.offstack.length;temp=context.offstack[len-1];context.offstack[len-1]=context.offstack[len-2];context.offstack[len-2]=temp},83:function(context,operands){oputil_unload_offstack(context);context.varsused.ix=true;context.varsused.pos=true;context.varsused.roll=true;context.varsused.vals1=true;var sign0=oputil_signify_operand(context,operands[0],true);var sign1=oputil_signify_operand(context,operands[1],true);context.code.push("if ("+sign0+" > 0) {");context.code.push("if ("+sign1+" > 0) {");context.code.push("vals1 = "+sign1+" % "+sign0+";");context.code.push("} else {");context.code.push("vals1 = "+sign0+" - (-("+sign1+")) % "+sign0+";");context.code.push("}");context.code.push("if (vals1) {");context.code.push("pos = frame.valstack.length - "+sign0+";");context.code.push("roll = frame.valstack.slice(frame.valstack.length-vals1, frame.valstack.length).concat(frame.valstack.slice(pos, frame.valstack.length-vals1));");context.code.push("for (ix=0; ix<"+sign0+"; ix++) { frame.valstack[pos+ix] = roll[ix]; }");context.code.push("roll = undefined;");context.code.push("}");context.code.push("}")},84:function(context,operands){oputil_unload_offstack(context);if(quot_isconstant(operands[0])){var ix,holdvar;var pos=Number(operands[0]);for(ix=0;ix<pos;ix++){holdvar=alloc_holdvar(context,true);context.offstack.push(holdvar);context.code.push(holdvar+"=frame.valstack[frame.valstack.length-"+(pos-ix)+"];")}}else{context.varsused.ix=true;context.varsused.jx=true;context.code.push("jx = frame.valstack.length-("+operands[0]+");");context.code.push("for (ix=0; ix<"+operands[0]+"; ix++) { frame.valstack.push(frame.valstack[jx+ix]); }")}},256:function(context,operands){var expr="do_gestalt(("+operands[0]+"),("+operands[1]+"))";context.code.push(operands[2]+expr+");")},257:function(context,operands){context.code.push("fatal_error('User debugtrap encountered.', "+operands[0]+");")},258:function(context,operands){context.code.push(operands[0]+"endmem);")},259:function(context,operands){context.code.push("change_memsize("+operands[0]+",false);");context.code.push(operands[1]+"0);")},272:function(context,operands){var expr;if(quot_isconstant(operands[0])){var val=Number(operands[0])&4294967295;if(val==0){expr="(Math.floor(random_func() * 0x10000) | (Math.floor(random_func() * 0x10000) << 16)) >>>0"}else{if(val>0){expr="Math.floor(random_func() * "+val+")"}else{expr="-Math.floor(random_func() * "+(-val)+")"}}}else{var sign0=oputil_signify_operand(context,operands[0],true);var holdvar=alloc_holdvar(context);expr=holdvar;context.code.push("if ("+sign0+" > 0)");context.code.push(holdvar+" = Math.floor(random_func() * "+sign0+");");context.code.push("else if ("+sign0+" < 0)");context.code.push(holdvar+" = -Math.floor(random_func() * -"+sign0+");");context.code.push("else");context.code.push(holdvar+" = (Math.floor(random_func() * 0x10000) | (Math.floor(random_func() * 0x10000) << 16)) >>>0;")}context.code.push(operands[1]+expr+");")},273:function(context,operands){context.code.push("set_random("+operands[0]+");")},288:function(context,operands){context.offstack.length=0;context.code.push("done_executing = true; vm_stopped = true;");context.code.push("return;");context.path_ends=true},289:function(context,operands){context.code.push(operands[0]+"perform_verify());")},290:function(context,operands){context.code.push("vm_restart();");context.code.push("return;");context.path_ends=true},291:function(context,operands){oputil_unload_offstack(context);context.varsused.ix=true;oputil_push_callstub(context,operands[1]);context.code.push("ix = vm_save("+operands[0]+");");context.code.push("pop_callstub(ix ? 0 : 1);");context.code.push("return;");context.path_ends=true},292:function(context,operands){oputil_unload_offstack(context);context.code.push("if (vm_restore("+operands[0]+")) {");context.code.push("pop_callstub((-1)>>>0);");context.code.push("} else {");context.code.push(operands[1]+"1);");context.code.push("pc = "+context.cp+";");context.code.push("}");context.code.push("return;");context.path_ends=true},293:function(context,operands){oputil_unload_offstack(context);oputil_push_callstub(context,operands[0]);context.code.push("vm_saveundo();");context.code.push("pop_callstub(0);");context.code.push("return;");context.path_ends=true},294:function(context,operands){oputil_unload_offstack(context);context.code.push("if (vm_restoreundo()) {");context.code.push("pop_callstub((-1)>>>0);");context.code.push("} else {");context.code.push(operands[0]+"1);");context.code.push("pc = "+context.cp+";");context.code.push("}");context.code.push("return;");context.path_ends=true},295:function(context,operands){context.code.push("protectstart="+operands[0]+";");context.code.push("protectend=protectstart+("+operands[1]+");");context.code.push("if (protectstart==protectend) {");context.code.push("  protectstart=0; protectend=0;");context.code.push("}")},368:function(context,operands){context.varsused.maddr=true;context.varsused.mlen=true;context.varsused.ix=true;context.code.push("mlen="+operands[0]+";");context.code.push("maddr="+operands[1]+";");context.code.push("for (ix=0; ix<mlen; ix++, maddr++) MemW1(maddr, 0);")},369:function(context,operands){context.varsused.msrc=true;context.varsused.mdest=true;context.varsused.mlen=true;context.varsused.ix=true;context.code.push("mlen="+operands[0]+";");context.code.push("msrc="+operands[1]+";");context.code.push("mdest="+operands[2]+";");context.code.push("if (mdest < msrc) {");context.code.push("for (ix=0; ix<mlen; ix++, msrc++, mdest++) MemW1(mdest, Mem1(msrc));");context.code.push("} else {");context.code.push("msrc += (mlen-1); mdest += (mlen-1);");context.code.push("for (ix=0; ix<mlen; ix++, msrc--, mdest--) MemW1(mdest, Mem1(msrc));");context.code.push("}")},376:function(context,operands){var expr="heap_malloc("+operands[0]+")";context.code.push(operands[1]+expr+");")},377:function(context,operands){context.code.push("heap_free("+operands[0]+");")},384:function(context,operands){},385:function(context,operands){},336:function(context,operands){var expr="linear_search(("+operands[0]+"),("+operands[1]+"),("+operands[2]+"),("+operands[3]+"),("+operands[4]+"),("+operands[5]+"),("+operands[6]+"))";context.code.push(operands[7]+expr+");")},337:function(context,operands){var expr="binary_search(("+operands[0]+"),("+operands[1]+"),("+operands[2]+"),("+operands[3]+"),("+operands[4]+"),("+operands[5]+"),("+operands[6]+"))";context.code.push(operands[7]+expr+");")},338:function(context,operands){var expr="linked_search(("+operands[0]+"),("+operands[1]+"),("+operands[2]+"),("+operands[3]+"),("+operands[4]+"),("+operands[5]+"))";context.code.push(operands[6]+expr+");")},112:function(context,operands){switch(context.curiosys){case 2:if(quot_isconstant(operands[0])){var val=Number(operands[0])&255;context.code.push("Glk.glk_put_char("+val+");")}else{context.code.push("Glk.glk_put_char(("+operands[0]+")&0xff);")}break;case 1:oputil_unload_offstack(context);context.code.push("tempcallargs[0]=(("+operands[0]+")&0xff);");oputil_push_callstub(context,"0,0");context.code.push("enter_function(iosysrock, 1);");context.code.push("return;");context.path_ends=true;break;case 0:break}},113:function(context,operands){switch(context.curiosys){case 2:var sign0=oputil_signify_operand(context,operands[0]);if(quot_isconstant(operands[0])){var val=Number(sign0).toString(10);context.code.push("Glk.glk_put_jstring("+QuoteEscapeString(val)+", true);")}else{context.code.push("Glk.glk_put_jstring(("+sign0+").toString(10), true);")}break;case 1:oputil_unload_offstack(context);context.code.push("stream_num("+context.cp+","+operands[0]+", false, 0);");context.code.push("return;");context.path_ends=true;break;case 0:break}},114:function(context,operands){oputil_unload_offstack(context);context.code.push("if (stream_string("+context.cp+","+operands[0]+", 0, 0)) return;")},115:function(context,operands){switch(context.curiosys){case 2:if(quot_isconstant(operands[0])){var val=Number(operands[0]);context.code.push("Glk.glk_put_char_uni("+val+");")}else{context.code.push("Glk.glk_put_char_uni("+operands[0]+");")}break;case 1:oputil_unload_offstack(context);context.code.push("tempcallargs[0]=("+operands[0]+");");oputil_push_callstub(context,"0,0");context.code.push("enter_function(iosysrock, 1);");context.code.push("return;");context.path_ends=true;break;case 0:break}},320:function(context,operands){context.code.push(operands[0]+"stringtable)")},321:function(context,operands){context.code.push("set_string_table("+operands[0]+");")},328:function(context,operands){context.code.push(operands[0]+"iosysmode)");context.code.push(operands[1]+"iosysrock)")},329:function(context,operands){context.code.push("set_iosys("+operands[0]+","+operands[1]+");");if(quot_isconstant(operands[0])){var val=Number(operands[0]);context.curiosys=val}else{oputil_unload_offstack(context);context.code.push("pc = "+context.cp+";");context.code.push("return;");context.path_ends=true}},400:function(context,operands){var sign0=oputil_signify_operand(context,operands[0]);if(quot_isconstant(operands[0])){var val=Number(sign0);context.code.push(operands[1]+encode_float(val)+");")}else{context.code.push(operands[1]+"encode_float("+sign0+"));")}},401:function(context,operands){context.varsused.valf=true;context.varsused.res=true;context.code.push("valf = "+oputil_decode_float(context,operands[0])+";");context.code.push("if (!("+operands[0]+" & 0x80000000)) {");context.code.push("  if (isNaN(valf) || !isFinite(valf) || (valf > 0x7fffffff))");context.code.push("    res = 0x7fffffff;");context.code.push("  else");context.code.push("    res = Math.floor(valf);");context.code.push("} else {");context.code.push("  if (isNaN(valf) || !isFinite(valf) || (valf < -0x80000000))");context.code.push("    res = -0x80000000;");context.code.push("  else");context.code.push("    res = Math.ceil(valf);");context.code.push("}");context.code.push(operands[1]+"res>>>0);")},402:function(context,operands){context.varsused.valf=true;context.varsused.res=true;context.code.push("valf = "+oputil_decode_float(context,operands[0])+";");context.code.push("if (!("+operands[0]+" & 0x80000000)) {");context.code.push("  if (isNaN(valf) || !isFinite(valf))");context.code.push("    res = 0x7fffffff;");context.code.push("  else");context.code.push("    res = Math.round(valf);");context.code.push("  if (res > 0x7fffffff) res = 0x7fffffff;");context.code.push("} else {");context.code.push("  if (isNaN(valf) || !isFinite(valf))");context.code.push("    res = -0x80000000;");context.code.push("  else");context.code.push("    res = Math.round(valf);");context.code.push("  if (res < -0x80000000) res = -0x80000000;");context.code.push("}");context.code.push(operands[1]+"res>>>0);")},408:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.ceil("+valf+")));")},409:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.floor("+valf+")));")},416:function(context,operands){var valf0=oputil_decode_float(context,operands[0]);var valf1=oputil_decode_float(context,operands[1]);context.code.push(operands[2]+"encode_float("+valf0+" + "+valf1+"));")},417:function(context,operands){var valf0=oputil_decode_float(context,operands[0]);var valf1=oputil_decode_float(context,operands[1]);context.code.push(operands[2]+"encode_float("+valf0+" - "+valf1+"));")},418:function(context,operands){var valf0=oputil_decode_float(context,operands[0]);var valf1=oputil_decode_float(context,operands[1]);context.code.push(operands[2]+"encode_float("+valf0+" * "+valf1+"));")},419:function(context,operands){var valf0=oputil_decode_float(context,operands[0]);var valf1=oputil_decode_float(context,operands[1]);context.code.push(operands[2]+"encode_float("+valf0+" / "+valf1+"));")},420:function(context,operands){var valf0=oputil_decode_float(context,operands[0],true);var valf1=oputil_decode_float(context,operands[1],true);context.varsused.modv=true;context.varsused.quov=true;context.code.push("modv=("+valf0+" % "+valf1+");");context.code.push("quov=encode_float(("+valf0+" - modv) / "+valf1+");");context.code.push("if (quov == 0x0 || quov == 0x80000000) {");context.code.push("  quov = (("+operands[0]+" ^ "+operands[1]+") & 0x80000000) >>>0;");context.code.push("}");context.code.push(operands[2]+"encode_float(modv));");context.code.push(operands[3]+"quov);")},424:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.sqrt("+valf+")));")},425:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.exp("+valf+")));")},426:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.log("+valf+")));")},427:function(context,operands){context.varsused.valf=true;var valf0=oputil_decode_float(context,operands[0],true);var valf1=oputil_decode_float(context,operands[1],true);context.code.push("if ("+operands[0]+" == 0x3f800000) {");context.code.push("  valf = 0x3f800000;");context.code.push("} else if ("+operands[0]+" == 0xbf800000 && ("+operands[1]+" == 0xff800000 || "+operands[1]+" == 0x7f800000)) {");context.code.push("  valf = 0x3f800000;");context.code.push("} else {");context.code.push("  valf=encode_float(Math.pow("+valf0+", "+valf1+"));");context.code.push("}");context.code.push(operands[2]+"valf);")},432:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.sin("+valf+")));")},433:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.cos("+valf+")));")},434:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.tan("+valf+")));")},435:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.asin("+valf+")));")},436:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.acos("+valf+")));")},437:function(context,operands){var valf=oputil_decode_float(context,operands[0]);context.code.push(operands[1]+"encode_float(Math.atan("+valf+")));")},438:function(context,operands){var valf0=oputil_decode_float(context,operands[0]);var valf1=oputil_decode_float(context,operands[1]);context.code.push(operands[2]+"encode_float(Math.atan2("+valf0+", "+valf1+")));")},448:function(context,operands){var val,valf0,valf1,valf2;context.varsused.fequal=true;context.varsused.fdiff=true;context.code.push("if (("+operands[2]+" & 0x7f800000) == 0x7f800000 && ("+operands[2]+" & 0x007fffff) != 0) {");context.code.push("  fequal = 0;");context.code.push("} else if (("+operands[0]+" == 0xff800000 || "+operands[0]+" == 0x7f800000) && ("+operands[1]+" == 0xff800000 || "+operands[1]+" == 0x7f800000)) {");context.code.push("  fequal = ("+operands[0]+" == "+operands[1]+");");context.code.push("} else {");if(quot_isconstant(operands[2])){val=Number(operands[2]);valf2=""+decode_float(val&2147483647)}else{val="decode_float(("+operands[2]+") & 0x7fffffff)";valf2=alloc_holdvar(context);context.code.push(valf2+"="+val+";")}valf0=oputil_decode_float(context,operands[0]);valf1=oputil_decode_float(context,operands[1]);context.code.push("  fdiff = "+valf1+" - "+valf0+";");context.code.push("  fequal = (fdiff <= "+valf2+" && fdiff >= -("+valf2+"));");context.code.push("}");context.code.push("if (fequal) {");oputil_perform_jump(context,operands[3]);context.code.push("}")},449:function(context,operands){var val,valf0,valf1,valf2;context.varsused.fequal=true;context.varsused.fdiff=true;context.code.push("if (("+operands[2]+" & 0x7f800000) == 0x7f800000 && ("+operands[2]+" & 0x007fffff) != 0) {");context.code.push("  fequal = 0;");context.code.push("} else if (("+operands[0]+" == 0xff800000 || "+operands[0]+" == 0x7f800000) && ("+operands[1]+" == 0xff800000 || "+operands[1]+" == 0x7f800000)) {");context.code.push("  fequal = ("+operands[0]+" == "+operands[1]+");");context.code.push("} else {");if(quot_isconstant(operands[2])){val=Number(operands[2]);valf2=""+decode_float(val&2147483647)}else{val="decode_float(("+operands[2]+") & 0x7fffffff)";valf2=alloc_holdvar(context);context.code.push(valf2+"="+val+";")}valf0=oputil_decode_float(context,operands[0]);valf1=oputil_decode_float(context,operands[1]);context.code.push("  fdiff = "+valf1+" - "+valf0+";");context.code.push("  fequal = (fdiff <= "+valf2+" && fdiff >= -("+valf2+"));");context.code.push("}");context.code.push("if (!fequal) {");oputil_perform_jump(context,operands[3]);context.code.push("}")},450:function(context,operands){valf0=oputil_decode_float(context,operands[0]);valf1=oputil_decode_float(context,operands[1]);context.code.push("if ("+valf0+" < "+valf1+") {");oputil_perform_jump(context,operands[2]);context.code.push("}")},451:function(context,operands){valf0=oputil_decode_float(context,operands[0]);valf1=oputil_decode_float(context,operands[1]);context.code.push("if ("+valf0+" <= "+valf1+") {");oputil_perform_jump(context,operands[2]);context.code.push("}")},452:function(context,operands){valf0=oputil_decode_float(context,operands[0]);valf1=oputil_decode_float(context,operands[1]);context.code.push("if ("+valf0+" > "+valf1+") {");oputil_perform_jump(context,operands[2]);context.code.push("}")},453:function(context,operands){valf0=oputil_decode_float(context,operands[0]);valf1=oputil_decode_float(context,operands[1]);context.code.push("if ("+valf0+" >= "+valf1+") {");oputil_perform_jump(context,operands[2]);context.code.push("}")},456:function(context,operands){context.code.push("if (("+operands[0]+" & 0x7f800000) == 0x7f800000 && ("+operands[0]+" & 0x007fffff) != 0) {");oputil_perform_jump(context,operands[1]);context.code.push("}")},457:function(context,operands){context.code.push("if ("+operands[0]+" == 0xff800000 || "+operands[0]+" == 0x7f800000) {");oputil_perform_jump(context,operands[1]);context.code.push("}")},304:function(context,operands){var mayblock;if(quot_isconstant(operands[0])){mayblock=Glk.call_may_not_return(Number(operands[0]))}else{mayblock=true}context.code.push("tempglkargs.length = "+operands[1]+";");if(quot_isconstant(operands[1])){var ix;var argc=Number(operands[1]);for(ix=0;ix<argc;ix++){if(context.offstack.length){var holdvar=pop_offstack_holdvar(context);context.code.push("tempglkargs["+ix+"]="+holdvar+";")}else{context.code.push("tempglkargs["+ix+"]=frame.valstack.pop();")}}oputil_unload_offstack(context)}else{context.varsused.ix=true;oputil_unload_offstack(context);context.code.push("for (ix=0; ix<"+operands[1]+"; ix++) { tempglkargs[ix]=frame.valstack.pop(); }")}context.varsused.glkret=true;context.code.push("glkret = GiDispa.get_function("+operands[0]+")(tempglkargs);");if(mayblock){context.code.push("if (glkret === Glk.DidNotReturn) {");context.code.push("  resumefuncop = "+oputil_record_funcop(operands[2])+";");context.code.push("  resumevalue = 0;");context.code.push("  pc = "+context.cp+";");context.code.push("  done_executing = true;");context.code.push("  return;");context.code.push("}")}oputil_store(context,operands[2],"glkret")}};function alloc_holdvar(context,use){var ix=0;var key;while(true){key="_hold"+ix;if(!context.holduse[key]){context.holduse[key]=(use?1:true);return key}ix++}}function pop_offstack_holdvar(context){var holdvar=context.offstack.pop();if(quot_isconstant(holdvar)){return holdvar}var use=context.holduse[holdvar];use--;if(use==0){use=true}context.holduse[holdvar]=use;return holdvar}function transfer_to_offstack(context,count){var holdvar;while(context.offstack.length<count){holdvar=alloc_holdvar(context,true);context.offstack.unshift(holdvar);context.code.push(holdvar+"=frame.valstack.pop();")}}function quot_isconstant(val){return(val[0]==="0")}function parse_operands(context,cp,oplist,operands){var modeaddr;var ix,modeval,mode;var value,addr;var holdvar;operands.desttype=0;operands.numops=oplist.numops;modeaddr=cp;cp+=((oplist.numops+1)>>1);for(ix=0;ix<oplist.numops;ix++){if((ix&1)==0){modeval=Mem1(modeaddr);mode=(modeval&15)}else{mode=((modeval>>4)&15);modeaddr++}var optype=oplist.formlist[ix];if(optype=="L"){switch(mode){case 8:if(context.offstack.length){operands[ix]=pop_offstack_holdvar(context)}else{holdvar=alloc_holdvar(context);context.code.push(holdvar+"=frame.valstack.pop();");operands[ix]=holdvar}continue;case 0:operands[ix]="0";continue;case 1:value=QuoteMem1(cp);cp++;operands[ix]=value;continue;case 2:value=QuoteMem2(cp);cp+=2;operands[ix]=value;continue;case 3:value=QuoteMem4(cp);cp+=4;operands[ix]=value;continue}if(mode>=9&&mode<=11){if(mode==9){addr=Mem1(cp);cp++}else{if(mode==10){addr=Mem2(cp);cp+=2}else{if(mode==11){addr=Mem4(cp);cp+=4}}}if(oplist.argsize==4){value="frame.locals["+addr+"]"}else{if(oplist.argsize==2){value="frame.locals["+addr+"] & 0xffff"}else{value="frame.locals["+addr+"] & 0xff"}}holdvar=alloc_holdvar(context);context.code.push(holdvar+"=("+value+");");operands[ix]=holdvar;continue}switch(mode){case 15:addr=Mem4(cp)+ramstart;cp+=4;break;case 14:addr=Mem2(cp)+ramstart;cp+=2;break;case 13:addr=Mem1(cp)+ramstart;cp++;break;case 7:addr=Mem4(cp);cp+=4;break;case 6:addr=Mem2(cp);cp+=2;break;case 5:addr=Mem1(cp);cp++;break;default:fatal_error("Unknown addressing mode in load operand.")}if(oplist.argsize==4){value="Mem4("+addr+")"}else{if(oplist.argsize==2){value="Mem2("+addr+")"}else{value="Mem1("+addr+")"}}holdvar=alloc_holdvar(context);context.code.push(holdvar+"=("+value+");");operands[ix]=holdvar;continue}else{if(optype=="E"){switch(mode){case 8:if(context.offstack.length){operands[ix]=pop_offstack_holdvar(context)}else{operands[ix]="frame.valstack.pop()"}continue;case 0:operands[ix]="0";continue;case 1:value=QuoteMem1(cp);cp++;operands[ix]=value;continue;case 2:value=QuoteMem2(cp);cp+=2;operands[ix]=value;continue;case 3:value=QuoteMem4(cp);cp+=4;operands[ix]=value;continue}if(mode>=9&&mode<=11){if(mode==9){addr=Mem1(cp);cp++}else{if(mode==10){addr=Mem2(cp);cp+=2}else{if(mode==11){addr=Mem4(cp);cp+=4}}}if(oplist.argsize==4){operands[ix]="frame.locals["+addr+"]"}else{if(oplist.argsize==2){operands[ix]="frame.locals["+addr+"] & 0xffff"}else{operands[ix]="frame.locals["+addr+"] & 0xff"}}continue}switch(mode){case 15:addr=Mem4(cp)+ramstart;cp+=4;break;case 14:addr=Mem2(cp)+ramstart;cp+=2;break;case 13:addr=Mem1(cp)+ramstart;cp++;break;case 7:addr=Mem4(cp);cp+=4;break;case 6:addr=Mem2(cp);cp+=2;break;case 5:addr=Mem1(cp);cp++;break;default:fatal_error("Unknown addressing mode in load operand.")}if(oplist.argsize==4){value="Mem4("+addr+")"}else{if(oplist.argsize==2){value="Mem2("+addr+")"}else{value="Mem1("+addr+")"}}operands[ix]=value;continue}else{if(optype=="S"){switch(mode){case 8:holdvar=alloc_holdvar(context,true);context.offstack.push(holdvar);operands[ix]=holdvar+"=(";continue;case 0:operands[ix]="(";continue}if(mode>=9&&mode<=11){if(mode==9){addr=Mem1(cp);cp++}else{if(mode==10){addr=Mem2(cp);cp+=2}else{if(mode==11){addr=Mem4(cp);cp+=4}}}if(oplist.argsize==4){operands[ix]="frame.locals["+addr+"]=("}else{if(oplist.argsize==2){operands[ix]="frame.locals["+addr+"]=(0xffff &"}else{operands[ix]="frame.locals["+addr+"]=(0xff &"}}continue}switch(mode){case 15:addr=Mem4(cp)+ramstart;cp+=4;break;case 14:addr=Mem2(cp)+ramstart;cp+=2;break;case 13:addr=Mem1(cp)+ramstart;cp++;break;case 7:addr=Mem4(cp);cp+=4;break;case 6:addr=Mem2(cp);cp+=2;break;case 5:addr=Mem1(cp);cp++;break;default:fatal_error("Unknown addressing mode in store operand.")}if(oplist.argsize==4){value="MemW4("+addr+","}else{if(oplist.argsize==2){value="MemW2("+addr+","}else{value="MemW1("+addr+","}}operands[ix]=value;continue}else{if(optype=="F"){var funcop=operands.func_store;switch(mode){case 8:funcop.mode=8;funcop.argsize=oplist.argsize;operands[ix]=funcop;continue;case 0:funcop.mode=0;funcop.argsize=oplist.argsize;operands[ix]=funcop;continue}if(mode>=9&&mode<=11){if(mode==9){addr=Mem1(cp);cp++}else{if(mode==10){addr=Mem2(cp);cp+=2}else{if(mode==11){addr=Mem4(cp);cp+=4}}}funcop.mode=11;funcop.addr=addr;funcop.argsize=oplist.argsize;operands[ix]=funcop;continue}switch(mode){case 15:addr=Mem4(cp)+ramstart;cp+=4;break;case 14:addr=Mem2(cp)+ramstart;cp+=2;break;case 13:addr=Mem1(cp)+ramstart;cp++;break;case 7:addr=Mem4(cp);cp+=4;break;case 6:addr=Mem2(cp);cp+=2;break;case 5:addr=Mem1(cp);cp++;break;default:fatal_error("Unknown addressing mode in store operand.")}funcop.mode=15;funcop.addr=addr;funcop.argsize=oplist.argsize;operands[ix]=funcop;continue}else{if(optype=="C"){switch(mode){case 8:operands[ix]="3,0";continue;case 0:operands[ix]="0,0";continue}if(mode>=9&&mode<=11){if(mode==9){addr=Mem1(cp);cp++}else{if(mode==10){addr=Mem2(cp);cp+=2}else{if(mode==11){addr=Mem4(cp);cp+=4}}}operands[ix]="2,"+addr;continue}switch(mode){case 15:addr=Mem4(cp)+ramstart;cp+=4;break;case 14:addr=Mem2(cp)+ramstart;cp+=2;break;case 13:addr=Mem1(cp)+ramstart;cp++;break;case 7:addr=Mem4(cp);cp+=4;break;case 6:addr=Mem2(cp);cp+=2;break;case 5:addr=Mem1(cp);cp++;break;default:fatal_error("Unknown addressing mode in store operand.")}operands[ix]="1,"+addr;continue}else{fatal_error("Unknown operand type.",optype)}}}}}}return cp}function compile_func(funcaddr){var addr=funcaddr;var functype=Mem1(addr);if(functype!=192&&functype!=193){if(functype>=192&&functype<=223){fatal_error("Call to unknown type of function.",addr)}else{fatal_error("Call to non-function.",addr)}}addr++;var localsformat=[];var rawstart=addr;var ix=0;while(1){var loctype=Mem1(addr);addr++;var locnum=Mem1(addr);addr++;if(loctype==0){break}if(loctype!=1&&loctype!=2&&loctype!=4){fatal_error("Invalid local variable size in function header.",loctype)}localsformat.push({size:loctype,count:locnum})}var rawformat=memmap.slice(rawstart,addr);while(rawformat.length%4){rawformat.push(0)}return new VMFunc(funcaddr,addr,localsformat,rawformat)}function compile_path(vmfunc,startaddr,startiosys){var cp=startaddr;var opcode;var opcodecp;var key;var context={vmfunc:vmfunc,cp:null,curiosys:startiosys,code:[],holduse:{},varsused:{},offstack:[],path_ends:false};var operands={};operands.func_store={};context.code.push("");while(!context.path_ends){opcodecp=cp;opcode=Mem1(cp);if(opcode===undefined){fatal_error("Tried to compile nonexistent address",cp)}cp++;if(opcode&128){if(opcode&64){opcode&=63;opcode=(opcode*256)|Mem1(cp);cp++;opcode=(opcode*256)|Mem1(cp);cp++;opcode=(opcode*256)|Mem1(cp);cp++}else{opcode&=127;opcode=(opcode*256)|Mem1(cp);cp++}}var oplist=operandlist_table[opcode];if(!oplist){fatal_error("Encountered unknown opcode.",opcode)}cp=parse_operands(context,cp,oplist,operands);context.cp=cp;var ophandler=opcode_table[opcode];if(!ophandler){fatal_error("Encountered unhandled opcode.",opcode)}ophandler(context,operands);for(key in context.holduse){if(context.holduse[key]===true){context.holduse[key]=false}}if(vmfunc.pathaddrs[cp]&&!context.path_ends){context.code.push("pc="+cp+";");oputil_unload_offstack(context);context.code.push("return;");context.path_ends=true}}if(context.offstack.length){fatal_error("Path compilation ended with nonempty offstack.",context.offstack.length)}var ls=[];for(key in context.holduse){ls.push(key)}for(key in context.varsused){ls.push(key)}if(ls.length){context.code[0]="var "+ls.join(",")+";"}return make_code(context.code.join("\n"))}function enter_function(addr,argcount){var ix;total_function_calls++;var vmfunc=vmfunc_table[addr];if(vmfunc===undefined){vmfunc=compile_func(addr);if(addr<ramstart){vmfunc_table[addr]=vmfunc}}pc=vmfunc.startpc;var newframe=new StackFrame(vmfunc);newframe.depth=stack.length;if(stack.length==0){newframe.framestart=0}else{newframe.framestart=frame.framestart+frame.framelen+4*frame.valstack.length}stack.push(newframe);frame=newframe;if(vmfunc.functype==192){for(ix=argcount-1;ix>=0;ix--){frame.valstack.push(tempcallargs[ix])}frame.valstack.push(argcount)}else{for(ix=0;ix<argcount;ix++){var form=vmfunc.localsindex[ix];if(form===undefined){break}if(form.size==4){frame.locals[form.pos]=tempcallargs[ix]}else{if(form.size==2){frame.locals[form.pos]=tempcallargs[ix]&65535}else{if(form.size==1){frame.locals[form.pos]=tempcallargs[ix]&255}}}}}}var ReturnedFromMain={dummy:"The top-level function has returned."};function leave_function(){var olddepth=frame.depth;stack.pop();if(stack.length==0){frame=null;throw ReturnedFromMain}frame=stack[stack.length-1];if(frame.depth!=olddepth-1){fatal_error("Stack inconsistent after function exit.")}}function pop_stack_to(val){while(stack.length&&stack[stack.length-1].framestart>val){stack.pop()}if(stack.length==0){fatal_error("Stack evaporated during throw.")}frame=stack[stack.length-1];val-=(frame.framestart+frame.framelen);if(val<0){fatal_error("Attempted to throw below the frame value stack.")}if(val&3){fatal_error("Attempted to throw to an unaligned address.")}val>>>=2;if(val>frame.valstack.length){fatal_error("Attempted to throw beyond the frame value stack.")}frame.valstack.length=val}function pop_callstub(val){var destaddr,desttype;if(isNaN(val)){fatal_error("Function returned undefined value.")}var framestart=frame.valstack.pop();if(framestart!=frame.framestart){fatal_error("Call stub frameptr ("+framestart+") does not match frame ("+frame.framestart+")")}pc=frame.valstack.pop();destaddr=frame.valstack.pop();desttype=frame.valstack.pop();switch(desttype){case 0:return;case 1:MemW4(destaddr,val);return;case 2:frame.locals[destaddr]=val;return;case 3:frame.valstack.push(val);return;case 17:fatal_error("String-terminator call stub at end of function call.");return;case 16:stream_string(0,pc,225,destaddr);return;case 18:stream_num(0,pc,true,destaddr);return;case 19:stream_string(0,pc,224,destaddr);return;case 20:stream_string(0,pc,226,destaddr);return;default:fatal_error("Unrecognized desttype in callstub.",desttype)}}function store_operand(desttype,destaddr,val){switch(desttype){case 0:return;case 1:MemW4(destaddr,val);return;case 2:frame.locals[destaddr]=val;return;case 3:frame.valstack.push(val);return;default:fatal_error("Unrecognized desttype in callstub.",desttype)}}function store_operand_by_funcop(funcop,val){if(!funcop){return}switch(funcop.mode){case 8:frame.valstack.push(val);return;case 0:return;case 11:if(funcop.argsize==4){frame.locals[funcop.addr]=(val)}else{if(funcop.argsize==2){frame.locals[funcop.addr]=(65535&val)}else{frame.locals[funcop.addr]=(255&val)}}return;case 15:if(funcop.argsize==4){MemW4(funcop.addr,val)}else{if(funcop.argsize==2){MemW2(funcop.addr,val)}else{MemW1(funcop.addr,val)}}return;default:fatal_error("Unknown addressing mode in store func by operand.")}}function set_random(val){if(val==0){random_func=Math.random}else{srand_set_seed(val);random_func=srand_get_random}}var srand_table=undefined;var srand_index1,srand_index2;function srand_set_seed(seed){var i,ii,k,val,loop;if(srand_table===undefined){srand_table=Array(55)}srand_table[54]=seed;srand_index1=0;srand_index2=31;k=1;for(i=0;i<55;i++){ii=(21*i)%55;srand_table[ii]=k;k=(seed-k)>>>0;seed=srand_table[ii]}for(loop=0;loop<4;loop++){for(i=0;i<55;i++){val=srand_table[i]-srand_table[(1+i+30)%55];srand_table[i]=val>>>0}}}function srand_get_random(){srand_index1=(srand_index1+1)%55;srand_index2=(srand_index2+1)%55;srand_table[srand_index1]=(srand_table[srand_index1]-srand_table[srand_index2])>>>0;return srand_table[srand_index1]/4294967296}function set_string_table(addr){if(stringtable==addr){return}decoding_tree=undefined;vmstring_table=undefined;stringtable=addr;if(stringtable==0){return}var textenv=vmtextenv_table[stringtable];if(textenv===undefined){var dectab=undefined;var tablelen=Mem4(stringtable);var rootaddr=Mem4(stringtable+8);var cache_stringtable=(stringtable+tablelen<=ramstart);if(cache_stringtable){var tmparray=Array(1);build_decoding_tree(tmparray,rootaddr,4,0);dectab=tmparray[0];if(dectab===undefined){fatal_error("Failed to create decoding tree.")}}textenv=new VMTextEnv(stringtable,dectab);vmtextenv_table[stringtable]=textenv}decoding_tree=textenv.decoding_tree;vmstring_table=textenv.vmstring_tables[iosysmode]}function set_iosys(mode,rock){switch(mode){case 0:rock=0;break;case 1:break;case 2:rock=0;break;default:mode=0;rock=0;break}iosysmode=mode;iosysrock=rock;var textenv=vmtextenv_table[stringtable];if(textenv===undefined){vmstring_table=undefined}else{vmstring_table=textenv.vmstring_tables[iosysmode]}}function build_decoding_tree(cablist,nodeaddr,depth,mask){var ix,type,cab;var depthbit;type=Mem1(nodeaddr);if(type==0&&depth==4){cab=Array(16);cab.type=0;cab.depth=4;cablist[mask]=cab;build_decoding_tree(cab,nodeaddr,0,0);return}if(type==0){var leftaddr=Mem4(nodeaddr+1);var rightaddr=Mem4(nodeaddr+5);build_decoding_tree(cablist,leftaddr,depth+1,mask);build_decoding_tree(cablist,rightaddr,depth+1,(mask|(1<<depth)));return}nodeaddr++;cab={};cab.type=type;cab.depth=depth;switch(type){case 2:cab.value=Mem1(nodeaddr);cab.cchar=CharToString(cab.value);break;case 4:cab.value=Mem4(nodeaddr);cab.cchar=CharToString(cab.value);break;case 3:case 5:cab.addr=nodeaddr;break;case 8:case 9:cab.addr=Mem4(nodeaddr);break;case 10:case 11:cab.addr=nodeaddr;break;case 1:break;default:fatal_error("Unknown node type in string table.",type)}depthbit=(1<<depth);for(ix=mask;ix<16;ix+=depthbit){cablist[ix]=cab}}function stream_num(nextcp,value,inmiddle,charnum){var buf=(value&4294967295).toString(10);switch(iosysmode){case 2:if(charnum){buf=buf.slice(charnum)}Glk.glk_put_jstring(buf,true);break;case 1:if(!inmiddle){frame.valstack.push(17,0,nextcp,frame.framestart);inmiddle=true}if(charnum<buf.length){var ch=buf.charCodeAt(charnum);frame.valstack.push(18,charnum+1,value,frame.framestart);tempcallargs[0]=ch;enter_function(iosysrock,1);return true}break;case 0:break}if(inmiddle){var desttype,destaddr;if(frame.valstack.pop()!=frame.framestart){fatal_error("Call stub frameptr does not match frame.")}pc=frame.valstack.pop();destaddr=frame.valstack.pop();desttype=frame.valstack.pop();if(desttype!=17){fatal_error("String-on-string call stub while printing number.")}}}function stream_string(nextcp,addr,inmiddle,bitnum){var substring=(inmiddle!=0);var addrkey,strop,res;var desttype,destaddr;while(true){strop=undefined;if(inmiddle==0){addrkey=addr}else{addrkey=addr+"/"+inmiddle+"/"+bitnum}if(vmstring_table!==undefined){strop=vmstring_table[addrkey];if(strop===undefined){strop=compile_string(iosysmode,addr,inmiddle,bitnum);vmstring_table[addrkey]=strop;strings_compiled++;strings_cached++}}else{strop=compile_string(iosysmode,addr,inmiddle,bitnum);strings_compiled++}if(!(strop instanceof Function)){Glk.glk_put_jstring(strop);if(!substring){return false}}else{res=strop(nextcp,substring);if(res instanceof Array){substring=true;addr=res[0];inmiddle=res[1];bitnum=res[2];continue}if(res){return true}}if(frame.valstack.pop()!=frame.framestart){fatal_error("Call stub frameptr does not match frame.")}pc=frame.valstack.pop();destaddr=frame.valstack.pop();desttype=frame.valstack.pop();if(desttype==17){return true}else{if(desttype==16){substring=true;bitnum=destaddr;inmiddle=225;addr=pc}else{fatal_error("Function-terminator call stub at end of string.")}}}}function compile_string(curiosys,startaddr,inmiddle,startbitnum){var addr=startaddr;var bitnum=startbitnum;var retval=undefined;var ch,type;if(!addr){fatal_error("Called compile_string with null address.")}var context={startaddr:startaddr,startbitnum:startbitnum,buffer:[],code:[]};if(inmiddle==0){type=Mem1(addr);if(type==226){addr+=4}else{addr++}bitnum=0}else{type=inmiddle}if(type==225){if(decoding_tree){var bits,numbits,readahead,tmpaddr;var cablist,cab;var done=false;bits=Mem1(addr);if(bitnum){bits>>=bitnum}numbits=(8-bitnum);readahead=false;if(!(decoding_tree instanceof Array)){done=true}cablist=decoding_tree;while(!done){if(numbits<4){var newbyte=Mem1(addr+1);bits|=(newbyte<<numbits);numbits+=8;readahead=true}cab=cablist[bits&15];numbits-=cab.depth;bits>>=cab.depth;bitnum+=cab.depth;if(bitnum>=8){addr+=1;bitnum-=8;if(readahead){readahead=false}else{var newbyte=Mem1(addr);bits|=(newbyte<<numbits);numbits+=8}}if(cab instanceof Array){cablist=cab;continue}switch(cab.type){case 1:done=true;break;case 2:case 4:switch(curiosys){case 2:context.buffer.push(cab.cchar);break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);oputil_push_callstub(context,"0x10,"+bitnum,addr);context.code.push("tempcallargs[0]="+cab.value+";");context.code.push("enter_function(iosysrock, 1);");retval=true;done=true;break}cablist=decoding_tree;break;case 3:switch(curiosys){case 2:tmpaddr=cab.addr;while(true){ch=Mem1(tmpaddr);if(ch==0){break}context.buffer.push(CharToString(ch));tmpaddr++}break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);oputil_push_callstub(context,"0x10,"+bitnum,addr);retval="["+(cab.addr)+", 0xE0, 0]";done=true;break}cablist=decoding_tree;break;case 5:switch(curiosys){case 2:tmpaddr=cab.addr;while(true){ch=Mem4(tmpaddr);if(ch==0){break}context.buffer.push(CharToString(ch));tmpaddr+=4}break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);oputil_push_callstub(context,"0x10,"+bitnum,addr);retval="["+(cab.addr)+", 0xE2, 0]";done=true;break}cablist=decoding_tree;break;case 8:case 9:case 10:case 11:oputil_flush_string(context);oputil_push_substring_callstub(context);context.code.push("var otype, retval;");context.code.push("var oaddr = "+(cab.addr)+";");if(cab.type>=9){context.code.push("oaddr = Mem4(oaddr);")}if(cab.type==11){context.code.push("oaddr = Mem4(oaddr);")}context.code.push("otype = Mem1(oaddr);");retval="retval";done=true;oputil_push_callstub(context,"0x10,"+bitnum,addr);context.code.push("if (otype >= 0xE0 && otype <= 0xFF) {");context.code.push("retval = [oaddr, 0, 0];");context.code.push("}");context.code.push("else if (otype >= 0xC0 && otype <= 0xDF) {");var argc=0;if(cab.type==10||cab.type==11){argc=Mem4(cab.addr+4);for(var ix=0;ix<argc;ix++){context.code.push("tempcallargs["+ix+"]="+Mem4(cab.addr+8+4*ix)+";")}}context.code.push("enter_function(oaddr, "+argc+");");context.code.push("retval = true;");context.code.push("}");context.code.push("else {");context.code.push("fatal_error('Unknown object while decoding string indirect reference.', otype);");context.code.push("}");break;default:fatal_error("Unknown entity in string decoding (cached).");break}}}else{var node,byt,nodetype;var done=false;if(!stringtable){fatal_error("Attempted to print a compressed string with no table set.")}byt=Mem1(addr);if(bitnum){byt>>=bitnum}node=Mem4(stringtable+8);while(!done){nodetype=Mem1(node);node++;switch(nodetype){case 0:if(byt&1){node=Mem4(node+4)}else{node=Mem4(node+0)}if(bitnum==7){bitnum=0;addr++;byt=Mem1(addr)}else{bitnum++;byt>>=1}break;case 1:retval=false;done=true;break;case 2:ch=Mem1(node);switch(curiosys){case 2:context.buffer.push(CharToString(ch));break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);oputil_push_callstub(context,"0x10,"+bitnum,addr);context.code.push("tempcallargs[0]="+ch+";");context.code.push("enter_function(iosysrock, 1);");retval=true;done=true;break}node=Mem4(stringtable+8);break;case 4:ch=Mem4(node);switch(curiosys){case 2:context.buffer.push(CharToString(ch));break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);oputil_push_callstub(context,"0x10,"+bitnum,addr);context.code.push("tempcallargs[0]="+ch+";");context.code.push("enter_function(iosysrock, 1);");retval=true;done=true;break}node=Mem4(stringtable+8);break;case 3:switch(curiosys){case 2:while(true){ch=Mem1(node);if(ch==0){break}context.buffer.push(CharToString(ch));node++}break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);oputil_push_callstub(context,"0x10,"+bitnum,addr);retval="["+node+", 0xE0, 0]";done=true;break}node=Mem4(stringtable+8);break;case 5:switch(curiosys){case 2:while(true){ch=Mem4(node);if(ch==0){break}context.buffer.push(CharToString(ch));node+=4}break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);oputil_push_callstub(context,"0x10,"+bitnum,addr);retval="["+node+", 0xE2, 0]";done=true;break}node=Mem4(stringtable+8);break;case 8:case 9:case 10:case 11:oputil_flush_string(context);oputil_push_substring_callstub(context);context.code.push("var otype, retval;");context.code.push("var oaddr = "+Mem4(node)+";");if(nodetype==9||nodetype==11){context.code.push("oaddr = Mem4(oaddr);")}context.code.push("otype = Mem1(oaddr);");retval="retval";done=true;oputil_push_callstub(context,"0x10,"+bitnum,addr);context.code.push("if (otype >= 0xE0 && otype <= 0xFF) {");context.code.push("retval = [oaddr, 0, 0];");context.code.push("}");context.code.push("else if (otype >= 0xC0 && otype <= 0xDF) {");var argc=0;if(nodetype==10||nodetype==11){argc=Mem4(node+4);for(var ix=0;ix<argc;ix++){context.code.push("tempcallargs["+ix+"]="+Mem4(node+8+4*ix)+";")}}context.code.push("enter_function(oaddr, "+argc+");");context.code.push("retval = true;");context.code.push("}");context.code.push("else {");context.code.push("fatal_error('Unknown object while decoding string indirect reference.', otype);");context.code.push("}");break;default:fatal_error("Unknown entity in string decoding.",nodetype);break}}}}else{if(type==224){var ch;switch(curiosys){case 2:while(1){ch=Mem1(addr);addr++;if(ch==0){break}context.buffer.push(CharToString(ch))}break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);ch=Mem1(addr);addr++;if(ch!=0){oputil_push_callstub(context,"0x13,0",addr);context.code.push("tempcallargs[0]="+ch+";");context.code.push("enter_function(iosysrock, 1);");retval=true}else{retval="false"}break}}else{if(type==226){var ch;switch(curiosys){case 2:while(1){ch=Mem4(addr);addr+=4;if(ch==0){break}context.buffer.push(CharToString(ch))}break;case 1:oputil_flush_string(context);oputil_push_substring_callstub(context);ch=Mem4(addr);addr+=4;if(ch!=0){oputil_push_callstub(context,"0x14,0",addr);context.code.push("tempcallargs[0]="+ch+";");context.code.push("enter_function(iosysrock, 1);");retval=true}else{retval="false"}break}}else{if(type>=224&&type<=255){fatal_error("Attempt to print unknown type of string.")}else{fatal_error("Attempt to print non-string.")}}}}if(!retval){return context.buffer.join("")}else{oputil_flush_string(context);context.code.push("return "+retval+";");return make_code(context.code.join("\n"),"nextcp,substring")}}function do_gestalt(val,val2){var ix;switch(val){case 0:return 196866;case 1:return 65539;case 2:return 1;case 3:return 1;case 4:switch(val2){case 0:return 1;case 1:return 1;case 2:return 1;default:return 0}break;case 5:return 1;case 6:return 1;case 7:return 1;case 8:return heap_get_start();case 9:return 1;case 10:return 0;case 11:return 1;default:return 0}}var tempsearchkey=[];function fetch_search_key(addr,len,options){var ix;tempsearchkey.length=len;if(options&1){for(ix=0;ix<len;ix++){tempsearchkey[ix]=Mem1(addr+ix)}}else{switch(len){case 4:tempsearchkey[0]=(addr>>24)&255;tempsearchkey[1]=(addr>>16)&255;tempsearchkey[2]=(addr>>8)&255;tempsearchkey[3]=addr&255;break;case 2:tempsearchkey[0]=(addr>>8)&255;tempsearchkey[1]=addr&255;break;case 1:tempsearchkey[0]=addr&255;break;default:throw ("Direct search key must hold one, two, or four bytes.")}}return tempsearchkey}function linear_search(key,keysize,start,structsize,numstructs,keyoffset,options){var ix,count,match,byt;var retindex=((options&4)!=0);var zeroterm=((options&2)!=0);var keybuf=fetch_search_key(key,keysize,options);for(count=0;count<numstructs;count++,start+=structsize){match=true;for(ix=0;match&&ix<keysize;ix++){byt=Mem1(start+keyoffset+ix);if(byt!=keybuf[ix]){match=false}}if(match){if(retindex){return count}else{return start}}if(zeroterm){match=true;for(ix=0;match&&ix<keysize;ix++){byt=Mem1(start+keyoffset+ix);if(byt!=0){match=false}}if(match){break}}}if(retindex){return 4294967295}else{return 0}}function binary_search(key,keysize,start,structsize,numstructs,keyoffset,options){var top,bot,addr,val,cmp,ix;var byt,byt2;var retindex=((options&4)!=0);var keybuf=fetch_search_key(key,keysize,options);bot=0;top=numstructs;while(bot<top){cmp=0;val=(top+bot)>>1;addr=start+val*structsize;for(ix=0;(!cmp)&&ix<keysize;ix++){byt=Mem1(addr+keyoffset+ix);byt2=keybuf[ix];if(byt<byt2){cmp=-1}else{if(byt>byt2){cmp=1}}}if(!cmp){if(retindex){return val}else{return addr}}if(cmp<0){bot=val+1}else{top=val}}if(retindex){return 4294967295}else{return 0}}function linked_search(key,keysize,start,keyoffset,nextoffset,options){var ix,byt,match;var zeroterm=((options&2)!=0);var keybuf=fetch_search_key(key,keysize,options);while(start!=0){match=true;for(ix=0;match&&ix<keysize;ix++){byt=Mem1(start+keyoffset+ix);if(byt!=keybuf[ix]){match=false}}if(match){return start}if(zeroterm){match=true;for(ix=0;match&&ix<keysize;ix++){byt=Mem1(start+keyoffset+ix);if(byt!=0){match=false}}if(match){break}}start=Mem4(start+nextoffset)}return 0}function decode_float(val){var sign,res,expo;if(val&2147483648){sign=true;val=val&2147483647}else{sign=false}if(val==0){return(sign?-0:0)}if((val&2139095040)==2139095040){if((val&8388607)==0){return(sign?-Infinity:Infinity)}else{return(sign?-NaN:NaN)}}expo=(val>>23&255);if(expo){res=((val&8388607|8388608)/8388608*Math.pow(2,(expo-127)))}else{res=((val&8388607)/8388608*Math.pow(2,-126))}if(sign){return -res}else{return res}}function encode_float(val){var absval,fbits;var mant,expo,sign;if(isNaN(val)){return 2139095041}if(!isFinite(val)){if(val<0){return 4286578688}else{return 2139095040}}if(val==0){if(1/val<0){return 2147483648}else{return 0}}if(val<0){sign=true;absval=-val}else{sign=false;absval=val}expo=Math.floor(Math.log(absval)/Math.log(2));mant=absval/Math.pow(2,expo);if(expo>=128){return(sign?4286578688:2139095040)}else{if(expo<-126){mant=mant*Math.pow(2,126+expo);expo=0}else{if(!(expo==0&&mant==0)){expo+=127;mant-=1}}}mant=mant*8388608;fbits=(mant+0.4999999999999999)<<0;if(fbits>=8388608){fbits=0;expo++;if(expo>=255){return(sign?4286578688:2139095040)}}if(sign){return((2147483648)|(expo<<23)|(fbits))>>>0}else{return(expo<<23)|(fbits)}}var game_image=null;var game_signature=null;var opt_rethrow_exceptions=null;var memmap;var stack;var frame;var vm_started=false;var vm_stopped=false;var tempcallargs;var tempglkargs;var done_executing;var vmfunc_table;var vmtextenv_table;var decoding_tree;var vmstring_table;var random_func;var ramstart;var endgamefile;var origendmem;var stacksize;var startfuncaddr;var origstringtable;var checksum;var pc;var stringtable;var endmem;var protectstart,protectend;var iosysmode,iosysrock;var undostack;var resumefuncop,resumevalue;var heapstart;var usedlist;var freelist;var total_execution_time=0;var total_function_calls=0;var total_path_calls=0;var paths_cached=0;var paths_compiled=0;var strings_cached=0;var strings_compiled=0;function setup_vm(){var val,version;if(!game_image){fatal_error("There is no Glulx game file loaded.")}vm_started=true;resumefuncop=null;resumevalue=0;memmap=null;stack=[];frame=null;pc=0;if(game_image.length<36){fatal_error("This is too short to be a valid Glulx file.")}val=ByteRead4(game_image,0);if(val!=1198290284){fatal_error("This is not a valid Glulx file.")}version=ByteRead4(game_image,4);if(version<131072){fatal_error("This Glulx file is too old a version to execute.")}if(version>=197120){fatal_error("This Glulx file is too new a version to execute.")}ramstart=ByteRead4(game_image,8);endgamefile=ByteRead4(game_image,12);origendmem=ByteRead4(game_image,16);stacksize=ByteRead4(game_image,20);startfuncaddr=ByteRead4(game_image,24);origstringtable=ByteRead4(game_image,28);checksum=ByteRead4(game_image,32);protectstart=0;protectend=0;if(ramstart<256||endgamefile<ramstart||origendmem<endgamefile){fatal_error("The segment boundaries in the header are in an impossible order.")}if(endgamefile!=game_image.length){fatal_error("The game file length does not agree with the header.")}done_executing=false;vmfunc_table={};vmtextenv_table={};decoding_tree=undefined;vmstring_table=undefined;tempcallargs=Array(8);tempglkargs=Array(1);set_random(0);endmem=origendmem;stringtable=0;undostack=[];heapstart=0;usedlist=[];freelist=[];vm_restart()}function vm_restart(){var ix;heap_clear();var protect=copy_protected_range();memmap=null;memmap=game_image.slice(0,endgamefile);endmem=memmap.length;change_memsize(origendmem,false);paste_protected_range(protect);stack=[];frame=null;pc=0;iosysmode=0;iosysrock=0;set_string_table(origstringtable);enter_function(startfuncaddr,0)}function compress_bytes(arr){result=[];var i=0;while(i<arr.length){var zeroes=0;while(i<arr.length&&arr[i]==0&&zeroes<=255){zeroes++;i++}if(zeroes>0){result.push(0);result.push(zeroes-1)}while(i<arr.length&&arr[i]!=0){result.push(arr[i]);i++}}return result}function decompress_bytes(arr){result=[];var i=0;while(i<arr.length){var b=arr[i++];if(b==0){var count=arr[i++]+1;for(var j=0;j<count;j++){result.push(0)}}else{result.push(b)}}return result}function pack_iff_chunks(chunks){keys=[];for(var key in chunks){if(key.length!=4){fatal_error("Bad chunk ID (must be exactly 4 chars): "+key)}keys.push(key)}keys.sort();bytes=[];for(var ix=0;ix<keys.length;ix++){var key=keys[ix];var chunk=chunks[key];BytePushString(bytes,key);BytePush4(bytes,chunk.length);bytes=bytes.concat(chunk)}return bytes}function unpack_iff_chunks(bytes){chunks={};var pos=0;while(pos<bytes.length){if((pos+8)>bytes.length){qlog("IFF chunk header is truncated");return undefined}var key=ByteReadString(bytes,pos,4);var size=ByteRead4(bytes,pos+4);pos+=8;if((pos+size)>bytes.length){qlog(key+" chunk is truncated ("+size+" bytes needed, "+(bytes.length-pos)+" available");return undefined}chunks[key]=bytes.slice(pos,pos+size);pos+=size}return chunks}function vm_save(streamid){if(iosysmode!=2){fatal_error("Streams are only available in Glk I/O system.")}var str=GiDispa.class_obj_from_id("stream",streamid);if(!str){return false}chunks={};chunks.IFhd=game_image.slice(0,128);chunks.CMem=memmap.slice(ramstart);for(var i=ramstart;i<game_image.length;i++){chunks.CMem[i-ramstart]^=game_image[i]}chunks.CMem=compress_bytes(chunks.CMem);chunks.QFun=[];for(var i=0;i<stack.length;i++){BytePush4(chunks.QFun,stack[i].vmfunc.funcaddr)}chunks.Stks=[];for(var i=0;i<stack.length;i++){push_serialized_stackframe(stack[i],chunks.Stks)}if(heap_is_active()){chunks.MAll=[];BytePush4(chunks.MAll,heapstart);BytePush4(chunks.MAll,usedlist.length);for(var i=0;i<usedlist.length;i++){BytePush4(chunks.MAll,usedlist[i].addr);BytePush4(chunks.MAll,usedlist[i].size)}}var payload_bytes=[];BytePushString(payload_bytes,"IFZS");payload_bytes=payload_bytes.concat(pack_iff_chunks(chunks));var quetzal=pack_iff_chunks({FORM:payload_bytes});Glk.glk_put_buffer_stream(str,quetzal);return true}function vm_restore(streamid){if(iosysmode!=2){fatal_error("Streams are only available in Glk I/O system.")}var str=GiDispa.class_obj_from_id("stream",streamid);if(!str){return false}var quetzal=new Array(0);var buffer=new Array(1024);var count=1;while(count>0){count=Glk.glk_get_buffer_stream(str,buffer);quetzal=quetzal.concat(buffer.slice(0,count))}quetzal=unpack_iff_chunks(quetzal);if(!quetzal){qlog("vm_restore failed: file is not Quetzal");return false}quetzal=quetzal.FORM;if(!quetzal||ByteReadString(quetzal,0,4)!="IFZS"){qlog("vm_restore failed: file doesn't start with FORM/IFZS header");return false}var chunks=unpack_iff_chunks(quetzal.slice(4));if(!chunks.IFhd){qlog("vm_restore failed: missing required IFhd chunk");return false}for(var i=0;i<128;i++){if(chunks.IFhd[i]!=game_image[i]){qlog("vm_restore failed: this save image is for a different game");return false}}if(!chunks.CMem){qlog("vm_restore failed: missing required CMem chunk");return false}if(!chunks.QFun){qlog("vm_restore failed: missing required QFun chunk")}if(!chunks.Stks){qlog("vm_restore failed: missing required Stks chunk")}var protect=copy_protected_range();heap_clear();var ram_xor=decompress_bytes(chunks.CMem);change_memsize(ramstart+ram_xor.length,false);memmap=game_image.slice(0,ramstart).concat(ram_xor);for(var i=ramstart;i<game_image.length;i++){memmap[i]^=game_image[i]}var vmfuncs=[];for(var pos=0;pos<chunks.QFun.length;pos+=4){var addr=ByteRead4(chunks.QFun,pos);var vmfunc=vmfunc_table[addr];if(vmfunc===undefined){vmfunc=compile_func(addr);if(addr<ramstart){vmfunc_table[addr]=vmfunc}}vmfuncs.push(vmfunc)}stack=[];for(var i=vmfuncs.length-1;i>=0;i--){frame=pop_deserialized_stackframe(chunks.Stks,vmfuncs[i]);if(!frame){fatal_error("vm_restore failed: bad stack frame")}stack.unshift(frame)}for(var i=0;i<stack.length;i++){stack[i].depth=i}frame=stack[stack.length-1];if(chunks.MAll){heapstart=ByteRead4(chunks.MAll,0);var numblocks=ByteRead4(chunks.MAll,4);var heapend=heapstart;for(var i=0;i<numblocks;i++){var addr=ByteRead4(chunks.MAll,8+4*i);var size=ByteRead4(chunks.MAll,12+4*i);if(addr<heapend||(addr+size)>endmem){fatal_error("vm_restore failed: corrupt dynamic heap")}usedlist.push(new HeapBlock(addr,size));if(addr>heapend){freelist.push(new HeapBlock(heapend,addr-heapend))}heapend=addr+size}if(heapend<endmem){freelist.push(new HeapBlock(heapend,endmem-heapend))}}paste_protected_range(protect);return true}function vm_saveundo(){var snapshot={};snapshot.ram=memmap.slice(ramstart);snapshot.endmem=endmem;snapshot.pc=pc;snapshot.stack=[];for(var i=0;i<stack.length;i++){snapshot.stack[i]=clone_stackframe(stack[i])}snapshot.heapstart=heapstart;snapshot.usedlist=usedlist.slice(0);snapshot.freelist=freelist.slice(0);undostack.push(snapshot);if(undostack.length>10){undostack.shift()}}function vm_restoreundo(){if(undostack.length==0){return false}var snapshot=undostack.pop();var protect=copy_protected_range();memmap=memmap.slice(0,ramstart).concat(snapshot.ram);endmem=snapshot.endmem;stack=snapshot.stack;frame=stack[stack.length-1];pc=snapshot.pc;heapstart=snapshot.heapstart;usedlist=snapshot.usedlist;freelist=snapshot.freelist;paste_protected_range(protect);return true}function change_memsize(newlen,internal){var lx;if(newlen==endmem){return}if((!internal)&&heap_is_active()){fatal_error("Cannot resize Glulx memory space while heap is active.")}if(newlen<origendmem){fatal_error("Cannot resize Glulx memory space smaller than it started.")}if(newlen&255){fatal_error("Can only resize Glulx memory space to a 256-byte boundary.")}memmap.length=newlen;if(newlen>endmem){for(lx=endmem;lx<newlen;lx++){memmap[lx]=0}}endmem=newlen}function copy_protected_range(){if(protectstart>=protectend){return null}var len=protectend-protectstart;var obj={start:protectstart,end:protectend,len:len};var arr=memmap.slice(protectstart,protectend);while(arr.length<len){arr.push(0)}obj.mem=arr;return obj}function paste_protected_range(obj){if(!obj){return}var ix,addr;var arr=obj.mem;var start=obj.start;var end=obj.end;if(end>endmem){end=endmem}for(ix=0,addr=start;addr<end;ix++,addr++){memmap[addr]=arr[ix]}}function perform_verify(){var imagelen=game_image.length;var ix,newsum,checksum;if(imagelen<256||(imagelen&255)!=0){return 1}if(imagelen!=ByteRead4(game_image,12)){return 1}checksum=ByteRead4(game_image,32);newsum=(-checksum)>>>0;for(ix=0;ix<imagelen;ix+=4){newsum=(newsum+ByteRead4(game_image,ix))>>>0}if(newsum!=checksum){return 1}return 0}function quixe_get_signature(){return game_signature}function quixe_get_statistics(){var stat={game_image_length:game_image.length,total_execution_time:total_execution_time,total_function_calls:total_function_calls,total_path_calls:total_path_calls,paths_cached:paths_cached,paths_compiled:paths_compiled,strings_cached:strings_cached,strings_compiled:strings_compiled};return stat}function heap_clear(){heapstart=0;usedlist=[];freelist=[]}function heap_is_active(){return(usedlist.length>0)}function heap_get_start(){return heapstart}function HeapBlock(addr,size){this.addr=addr;this.size=size;this.end=addr+size}function heap_binary_search(list,addr){var low=0;var high=list.length;while(low<high){var mid=(low+high)>>1;if(list[mid].addr<addr){low=mid+1}else{high=mid}}return low}function heap_malloc(size){if(!heap_is_active()){heapstart=endmem}for(var i=0,max=freelist.length;i<max;i++){var freeblock=freelist[i];if(freeblock.size>=size){if(freeblock.size>size){freelist[i]=new HeapBlock(freeblock.addr+size,freeblock.size-size)}else{freelist.splice(i,1)}var pos=heap_binary_search(usedlist,freeblock.addr);usedlist.splice(pos,0,new HeapBlock(freeblock.addr,size));return freeblock.addr}}var addr=endmem;var rounded_up_size=((size+255)&4294967040);change_memsize(endmem+rounded_up_size,true);if(rounded_up_size>size){freelist.push(new HeapBlock(addr+size,rounded_up_size-size))}usedlist.push(new HeapBlock(addr,size));return addr}function heap_free(addr){var pos=heap_binary_search(usedlist,addr);var block=usedlist[pos];if(!block||block.addr!=addr){fatal_error("Tried to free non-existent block")}usedlist.splice(pos,1);if(usedlist.length==0){change_memsize(heapstart,true);heap_clear();return}pos=heap_binary_search(freelist,addr);var next=freelist[pos];if(next&&next.addr==block.end){block=new HeapBlock(addr,block.size+next.size);freelist.splice(pos,1)}var prev=freelist[pos-1];if(prev&&prev.end==block.addr){block=new HeapBlock(prev.addr,prev.size+block.size);freelist.splice(pos-1,1);pos-=1}freelist.splice(pos,0,block)}function assert_heap_valid(){if(!heap_is_active()){if(heapstart!=0){fatal_error("Heap inconsistency: heapstart nonzero")}if(usedlist.length>0){fatal_error("Heap inconsistency: usedlist nonempty")}if(freelist.length>0){fatal_error("Heap inconsistency: usedlist nonempty")}return}if(heapstart==0){fatal_error("Heap inconsistency: heapstart is zero")}var addr=heapstart;var upos=0,fpos=0;while(upos<usedlist.length||fpos<freelist.length){var u=usedlist[upos];var f=freelist[fpos];if(u&&u.addr==addr){addr+=u.size;upos++}else{if(f&&f.addr==addr){addr+=f.size;fpos++}else{fatal_error("Heap inconsistency: no block at address "+addr)}}}if(addr!=endmem){fatal_error("Heap inconsistency: overrun at end of heap")}}function execute_loop(){var vmfunc,pathtab,path;var pathstart,pathend;if(resumefuncop){store_operand_by_funcop(resumefuncop,resumevalue);resumefuncop=null;resumevalue=0}pathstart=new Date().getTime();while(!done_executing){vmfunc=frame.vmfunc;pathtab=vmfunc[iosysmode];path=pathtab[pc];if(path===undefined){vmfunc.pathaddrs[pc]=true;path=compile_path(vmfunc,pc,iosysmode);paths_compiled++;if(pc<ramstart){pathtab[pc]=path;paths_cached++}}total_path_calls++;try{path()}catch(ex){if(ex===ReturnedFromMain){done_executing=true;vm_stopped=true}else{throw ex}}}pathend=new Date().getTime();total_execution_time+=(pathend-pathstart)/1000;if(vm_stopped){Glk.glk_exit()}Glk.update();qlog("### done executing; path time = "+(pathend-pathstart)+" ms")}return{version:"1.0.3",prepare:quixe_prepare,init:quixe_init,resume:quixe_resume,get_signature:quixe_get_signature,get_statistics:quixe_get_statistics,ReadByte:ReadArgByte,WriteByte:WriteArgByte,ReadWord:ReadArgWord,WriteWord:WriteArgWord,ReadStructField:ReadStructField,WriteStructField:WriteStructField,SetResumeStore:SetResumeStore}}();GiDispa=function(){var VM=null;function set_vm(vm_api){VM=vm_api}var class_defs={0:"window",1:"stream",2:"fileref",3:"schannel"};function FuncSpec(id,name,proto){this.id=id;this.name=name;this.proto=proto}function Prototype(args,retarg){this.args=args;this.retarg=retarg}function ArgString(){this.macro="Byte";this.refsize=1}function ArgUnicode(){this.macro="Word";this.refsize=4}function ArgChar(signed){this.signed=signed;this.macro="Byte";this.refsize=1;this.literal=(signed?"arg_char_signed":"arg_char_unsigned")}function ArgInt(signed){this.signed=signed;this.macro="Word";this.refsize=4;this.literal=(signed?"arg_int_signed":"arg_int_unsigned")}function ArgClass(name){this.name=name;this.macro="Word";this.refsize=4}function ArgStruct(form){this.form=form}function ArgRef(arg,passin,passout,nonnull){this.arg=arg;this.passin=passin;this.passout=passout;this.nonnull=nonnull}function ArgArray(arg,retained,passin,passout,nonnull){this.arg=arg;this.retained=retained;this.passin=passin;this.passout=passout;this.nonnull=nonnull}var arg_int_unsigned=new ArgInt(false);var arg_int_signed=new ArgInt(true);var arg_char_unsigned=new ArgChar(false);var arg_char_signed=new ArgChar(true);var proto_map={1:new FuncSpec(1,"exit",new Prototype([],null)),3:new FuncSpec(3,"tick",new Prototype([],null)),4:new FuncSpec(4,"gestalt",new Prototype([new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgInt(false),false,true,true))),5:new FuncSpec(5,"gestalt_ext",new Prototype([new ArgInt(false),new ArgInt(false),new ArgArray(new ArgInt(false),false,true,true,false)],new ArgRef(new ArgInt(false),false,true,true))),32:new FuncSpec(32,"window_iterate",new Prototype([new ArgClass("window"),new ArgRef(new ArgInt(false),false,true,false)],new ArgRef(new ArgClass("window"),false,true,true))),33:new FuncSpec(33,"window_get_rock",new Prototype([new ArgClass("window")],new ArgRef(new ArgInt(false),false,true,true))),34:new FuncSpec(34,"window_get_root",new Prototype([],new ArgRef(new ArgClass("window"),false,true,true))),35:new FuncSpec(35,"window_open",new Prototype([new ArgClass("window"),new ArgInt(false),new ArgInt(false),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgClass("window"),false,true,true))),36:new FuncSpec(36,"window_close",new Prototype([new ArgClass("window"),new ArgRef(new ArgStruct(new Prototype([new ArgInt(false),new ArgInt(false)],null)),false,true,false)],null)),37:new FuncSpec(37,"window_get_size",new Prototype([new ArgClass("window"),new ArgRef(new ArgInt(false),false,true,false),new ArgRef(new ArgInt(false),false,true,false)],null)),38:new FuncSpec(38,"window_set_arrangement",new Prototype([new ArgClass("window"),new ArgInt(false),new ArgInt(false),new ArgClass("window")],null)),39:new FuncSpec(39,"window_get_arrangement",new Prototype([new ArgClass("window"),new ArgRef(new ArgInt(false),false,true,false),new ArgRef(new ArgInt(false),false,true,false),new ArgRef(new ArgClass("window"),false,true,false)],null)),40:new FuncSpec(40,"window_get_type",new Prototype([new ArgClass("window")],new ArgRef(new ArgInt(false),false,true,true))),41:new FuncSpec(41,"window_get_parent",new Prototype([new ArgClass("window")],new ArgRef(new ArgClass("window"),false,true,true))),42:new FuncSpec(42,"window_clear",new Prototype([new ArgClass("window")],null)),43:new FuncSpec(43,"window_move_cursor",new Prototype([new ArgClass("window"),new ArgInt(false),new ArgInt(false)],null)),44:new FuncSpec(44,"window_get_stream",new Prototype([new ArgClass("window")],new ArgRef(new ArgClass("stream"),false,true,true))),45:new FuncSpec(45,"window_set_echo_stream",new Prototype([new ArgClass("window"),new ArgClass("stream")],null)),46:new FuncSpec(46,"window_get_echo_stream",new Prototype([new ArgClass("window")],new ArgRef(new ArgClass("stream"),false,true,true))),47:new FuncSpec(47,"set_window",new Prototype([new ArgClass("window")],null)),48:new FuncSpec(48,"window_get_sibling",new Prototype([new ArgClass("window")],new ArgRef(new ArgClass("window"),false,true,true))),64:new FuncSpec(64,"stream_iterate",new Prototype([new ArgClass("stream"),new ArgRef(new ArgInt(false),false,true,false)],new ArgRef(new ArgClass("stream"),false,true,true))),65:new FuncSpec(65,"stream_get_rock",new Prototype([new ArgClass("stream")],new ArgRef(new ArgInt(false),false,true,true))),66:new FuncSpec(66,"stream_open_file",new Prototype([new ArgClass("fileref"),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgClass("stream"),false,true,true))),67:new FuncSpec(67,"stream_open_memory",new Prototype([new ArgArray(new ArgChar(null),true,true,true,true),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgClass("stream"),false,true,true))),68:new FuncSpec(68,"stream_close",new Prototype([new ArgClass("stream"),new ArgRef(new ArgStruct(new Prototype([new ArgInt(false),new ArgInt(false)],null)),false,true,false)],null)),69:new FuncSpec(69,"stream_set_position",new Prototype([new ArgClass("stream"),new ArgInt(true),new ArgInt(false)],null)),70:new FuncSpec(70,"stream_get_position",new Prototype([new ArgClass("stream")],new ArgRef(new ArgInt(false),false,true,true))),71:new FuncSpec(71,"stream_set_current",new Prototype([new ArgClass("stream")],null)),72:new FuncSpec(72,"stream_get_current",new Prototype([],new ArgRef(new ArgClass("stream"),false,true,true))),96:new FuncSpec(96,"fileref_create_temp",new Prototype([new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgClass("fileref"),false,true,true))),97:new FuncSpec(97,"fileref_create_by_name",new Prototype([new ArgInt(false),new ArgString(),new ArgInt(false)],new ArgRef(new ArgClass("fileref"),false,true,true))),98:new FuncSpec(98,"fileref_create_by_prompt",new Prototype([new ArgInt(false),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgClass("fileref"),false,true,true))),99:new FuncSpec(99,"fileref_destroy",new Prototype([new ArgClass("fileref")],null)),100:new FuncSpec(100,"fileref_iterate",new Prototype([new ArgClass("fileref"),new ArgRef(new ArgInt(false),false,true,false)],new ArgRef(new ArgClass("fileref"),false,true,true))),101:new FuncSpec(101,"fileref_get_rock",new Prototype([new ArgClass("fileref")],new ArgRef(new ArgInt(false),false,true,true))),102:new FuncSpec(102,"fileref_delete_file",new Prototype([new ArgClass("fileref")],null)),103:new FuncSpec(103,"fileref_does_file_exist",new Prototype([new ArgClass("fileref")],new ArgRef(new ArgInt(false),false,true,true))),104:new FuncSpec(104,"fileref_create_from_fileref",new Prototype([new ArgInt(false),new ArgClass("fileref"),new ArgInt(false)],new ArgRef(new ArgClass("fileref"),false,true,true))),128:new FuncSpec(128,"put_char",new Prototype([new ArgChar(false)],null)),129:new FuncSpec(129,"put_char_stream",new Prototype([new ArgClass("stream"),new ArgChar(false)],null)),130:new FuncSpec(130,"put_string",new Prototype([new ArgString()],null)),131:new FuncSpec(131,"put_string_stream",new Prototype([new ArgClass("stream"),new ArgString()],null)),132:new FuncSpec(132,"put_buffer",new Prototype([new ArgArray(new ArgChar(null),false,true,false,true)],null)),133:new FuncSpec(133,"put_buffer_stream",new Prototype([new ArgClass("stream"),new ArgArray(new ArgChar(null),false,true,false,true)],null)),134:new FuncSpec(134,"set_style",new Prototype([new ArgInt(false)],null)),135:new FuncSpec(135,"set_style_stream",new Prototype([new ArgClass("stream"),new ArgInt(false)],null)),144:new FuncSpec(144,"get_char_stream",new Prototype([new ArgClass("stream")],new ArgRef(new ArgInt(true),false,true,true))),145:new FuncSpec(145,"get_line_stream",new Prototype([new ArgClass("stream"),new ArgArray(new ArgChar(null),false,false,true,true)],new ArgRef(new ArgInt(false),false,true,true))),146:new FuncSpec(146,"get_buffer_stream",new Prototype([new ArgClass("stream"),new ArgArray(new ArgChar(null),false,false,true,true)],new ArgRef(new ArgInt(false),false,true,true))),160:new FuncSpec(160,"char_to_lower",new Prototype([new ArgChar(false)],new ArgRef(new ArgChar(false),false,true,true))),161:new FuncSpec(161,"char_to_upper",new Prototype([new ArgChar(false)],new ArgRef(new ArgChar(false),false,true,true))),176:new FuncSpec(176,"stylehint_set",new Prototype([new ArgInt(false),new ArgInt(false),new ArgInt(false),new ArgInt(true)],null)),177:new FuncSpec(177,"stylehint_clear",new Prototype([new ArgInt(false),new ArgInt(false),new ArgInt(false)],null)),178:new FuncSpec(178,"style_distinguish",new Prototype([new ArgClass("window"),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgInt(false),false,true,true))),179:new FuncSpec(179,"style_measure",new Prototype([new ArgClass("window"),new ArgInt(false),new ArgInt(false),new ArgRef(new ArgInt(false),false,true,false)],new ArgRef(new ArgInt(false),false,true,true))),192:new FuncSpec(192,"select",new Prototype([new ArgRef(new ArgStruct(new Prototype([new ArgInt(false),new ArgClass("window"),new ArgInt(false),new ArgInt(false)],null)),false,true,true)],null)),193:new FuncSpec(193,"select_poll",new Prototype([new ArgRef(new ArgStruct(new Prototype([new ArgInt(false),new ArgClass("window"),new ArgInt(false),new ArgInt(false)],null)),false,true,true)],null)),208:new FuncSpec(208,"request_line_event",new Prototype([new ArgClass("window"),new ArgArray(new ArgChar(null),true,true,true,true),new ArgInt(false)],null)),209:new FuncSpec(209,"cancel_line_event",new Prototype([new ArgClass("window"),new ArgRef(new ArgStruct(new Prototype([new ArgInt(false),new ArgClass("window"),new ArgInt(false),new ArgInt(false)],null)),false,true,false)],null)),210:new FuncSpec(210,"request_char_event",new Prototype([new ArgClass("window")],null)),211:new FuncSpec(211,"cancel_char_event",new Prototype([new ArgClass("window")],null)),212:new FuncSpec(212,"request_mouse_event",new Prototype([new ArgClass("window")],null)),213:new FuncSpec(213,"cancel_mouse_event",new Prototype([new ArgClass("window")],null)),214:new FuncSpec(214,"request_timer_events",new Prototype([new ArgInt(false)],null)),224:new FuncSpec(224,"image_get_info",new Prototype([new ArgInt(false),new ArgRef(new ArgInt(false),false,true,false),new ArgRef(new ArgInt(false),false,true,false)],new ArgRef(new ArgInt(false),false,true,true))),225:new FuncSpec(225,"image_draw",new Prototype([new ArgClass("window"),new ArgInt(false),new ArgInt(true),new ArgInt(true)],new ArgRef(new ArgInt(false),false,true,true))),226:new FuncSpec(226,"image_draw_scaled",new Prototype([new ArgClass("window"),new ArgInt(false),new ArgInt(true),new ArgInt(true),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgInt(false),false,true,true))),232:new FuncSpec(232,"window_flow_break",new Prototype([new ArgClass("window")],null)),233:new FuncSpec(233,"window_erase_rect",new Prototype([new ArgClass("window"),new ArgInt(true),new ArgInt(true),new ArgInt(false),new ArgInt(false)],null)),234:new FuncSpec(234,"window_fill_rect",new Prototype([new ArgClass("window"),new ArgInt(false),new ArgInt(true),new ArgInt(true),new ArgInt(false),new ArgInt(false)],null)),235:new FuncSpec(235,"window_set_background_color",new Prototype([new ArgClass("window"),new ArgInt(false)],null)),240:new FuncSpec(240,"schannel_iterate",new Prototype([new ArgClass("schannel"),new ArgRef(new ArgInt(false),false,true,false)],new ArgRef(new ArgClass("schannel"),false,true,true))),241:new FuncSpec(241,"schannel_get_rock",new Prototype([new ArgClass("schannel")],new ArgRef(new ArgInt(false),false,true,true))),242:new FuncSpec(242,"schannel_create",new Prototype([new ArgInt(false)],new ArgRef(new ArgClass("schannel"),false,true,true))),243:new FuncSpec(243,"schannel_destroy",new Prototype([new ArgClass("schannel")],null)),248:new FuncSpec(248,"schannel_play",new Prototype([new ArgClass("schannel"),new ArgInt(false)],new ArgRef(new ArgInt(false),false,true,true))),249:new FuncSpec(249,"schannel_play_ext",new Prototype([new ArgClass("schannel"),new ArgInt(false),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgInt(false),false,true,true))),250:new FuncSpec(250,"schannel_stop",new Prototype([new ArgClass("schannel")],null)),251:new FuncSpec(251,"schannel_set_volume",new Prototype([new ArgClass("schannel"),new ArgInt(false)],null)),252:new FuncSpec(252,"sound_load_hint",new Prototype([new ArgInt(false),new ArgInt(false)],null)),256:new FuncSpec(256,"set_hyperlink",new Prototype([new ArgInt(false)],null)),257:new FuncSpec(257,"set_hyperlink_stream",new Prototype([new ArgClass("stream"),new ArgInt(false)],null)),258:new FuncSpec(258,"request_hyperlink_event",new Prototype([new ArgClass("window")],null)),259:new FuncSpec(259,"cancel_hyperlink_event",new Prototype([new ArgClass("window")],null)),288:new FuncSpec(288,"buffer_to_lower_case_uni",new Prototype([new ArgArray(new ArgInt(false),false,true,true,true),new ArgInt(false)],new ArgRef(new ArgInt(false),false,true,true))),289:new FuncSpec(289,"buffer_to_upper_case_uni",new Prototype([new ArgArray(new ArgInt(false),false,true,true,true),new ArgInt(false)],new ArgRef(new ArgInt(false),false,true,true))),290:new FuncSpec(290,"buffer_to_title_case_uni",new Prototype([new ArgArray(new ArgInt(false),false,true,true,true),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgInt(false),false,true,true))),296:new FuncSpec(296,"put_char_uni",new Prototype([new ArgInt(false)],null)),297:new FuncSpec(297,"put_string_uni",new Prototype([new ArgUnicode()],null)),298:new FuncSpec(298,"put_buffer_uni",new Prototype([new ArgArray(new ArgInt(false),false,true,false,true)],null)),299:new FuncSpec(299,"put_char_stream_uni",new Prototype([new ArgClass("stream"),new ArgInt(false)],null)),300:new FuncSpec(300,"put_string_stream_uni",new Prototype([new ArgClass("stream"),new ArgUnicode()],null)),301:new FuncSpec(301,"put_buffer_stream_uni",new Prototype([new ArgClass("stream"),new ArgArray(new ArgInt(false),false,true,false,true)],null)),304:new FuncSpec(304,"get_char_stream_uni",new Prototype([new ArgClass("stream")],new ArgRef(new ArgInt(true),false,true,true))),305:new FuncSpec(305,"get_buffer_stream_uni",new Prototype([new ArgClass("stream"),new ArgArray(new ArgInt(false),false,false,true,true)],new ArgRef(new ArgInt(false),false,true,true))),306:new FuncSpec(306,"get_line_stream_uni",new Prototype([new ArgClass("stream"),new ArgArray(new ArgInt(false),false,false,true,true)],new ArgRef(new ArgInt(false),false,true,true))),312:new FuncSpec(312,"stream_open_file_uni",new Prototype([new ArgClass("fileref"),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgClass("stream"),false,true,true))),313:new FuncSpec(313,"stream_open_memory_uni",new Prototype([new ArgArray(new ArgInt(false),true,true,true,true),new ArgInt(false),new ArgInt(false)],new ArgRef(new ArgClass("stream"),false,true,true))),320:new FuncSpec(320,"request_char_event_uni",new Prototype([new ArgClass("window")],null)),321:new FuncSpec(321,"request_line_event_uni",new Prototype([new ArgClass("window"),new ArgArray(new ArgInt(false),true,true,true,true),new ArgInt(false)],null))};function convert_arg(arg,passin,val){if(arg instanceof ArgInt){if(passin){if(!arg.signed){return val}else{return val+" & 0xFFFFFFFF"}}else{return"0"}}if(arg instanceof ArgChar){if(passin){if(!arg.signed){return val+" & 0xFF"}else{return"cast_signed_char("+val+")"}}else{return"0"}}if(arg instanceof ArgClass){if(passin){return'class_obj_from_id("'+arg.name+'", '+val+")"}else{return"null"}}return"???"}function unconvert_arg(arg,val){if(arg instanceof ArgInt){return val+" >>> 0"}if(arg instanceof ArgChar){if(!arg.signed){return val+" & 0xFF"}else{return"uncast_signed_char("+val+")"}}if(arg instanceof ArgClass){return'class_obj_to_id("'+arg.name+'", '+val+")"}return"???"}function cast_signed_char(val){val=val&255;if(val&128){val-=256}return val}function uncast_signed_char(val){val=val&255;if(val&128){val+=4294967040}return val}function class_obj_to_id(clas,val){if(!val){return 0}return val.disprock}function class_obj_from_id(clas,val){if(val==0){return null}return class_map[clas][val]}function build_function(func){var ix,jx;var form,retarg,argpos,argjoin,subargs;var arg,refarg,tmpvar,val,retval,ls;var mayblock;var out=[];var locals={};var arraycount=0;out.push("// no local vars");out.push("// "+func.id+": "+func.name);form=func.proto;retarg=null;if(form.retarg){retarg=form.retarg.arg}mayblock=Glk.call_may_not_return(func.id);argpos=0;argjoin=[];for(ix=0;ix<form.args.length;ix++){arg=form.args[ix];tmpvar="glka"+ix;argjoin.push(tmpvar);locals[tmpvar]=true;if((arg instanceof ArgInt)||(arg instanceof ArgChar)||(arg instanceof ArgClass)){val=convert_arg(arg,true,"callargs["+argpos+"]");out.push(tmpvar+" = "+val+";");argpos+=1}else{if(arg instanceof ArgRef){refarg=arg.arg;out.push("if (callargs["+argpos+"] == 0) {");if(arg.nonnull){out.push('  throw("glk '+func.name+': null argument");')}else{out.push("  "+tmpvar+" = null;")}out.push("} else {");if((refarg instanceof ArgInt)||(refarg instanceof ArgChar)||(refarg instanceof ArgClass)){out.push("  "+tmpvar+" = new Glk.RefBox();");val=convert_arg(refarg,arg.passin,"VM.ReadWord(callargs["+argpos+"])");out.push("  "+tmpvar+".set_value("+val+");")}else{if(refarg instanceof ArgStruct){subargs=refarg.form.args;out.push("  "+tmpvar+" = new Glk.RefStruct("+subargs.length+");");for(jx=0;jx<subargs.length;jx++){val=convert_arg(subargs[jx],arg.passin,"VM.ReadStructField(callargs["+argpos+"], "+jx+")");out.push("  "+tmpvar+".push_field("+val+");")}}else{throw ("buildfunc: unsupported refarg type: "+func.name)}}out.push("}");argpos+=1}else{if(arg instanceof ArgArray){locals.glklen=true;refarg=arg.arg;out.push("if (callargs["+argpos+"] == 0) {");if(arg.nonnull){out.push('  throw("glk '+func.name+': null argument");')}else{out.push("  "+tmpvar+" = null;")}out.push("} else {");out.push("  glklen = callargs["+(argpos+1)+"];");out.push("  "+tmpvar+" = Array(glklen);");if(arg.passin){locals.ix=true;locals.jx=true;out.push("  for (ix=0, jx=callargs["+argpos+"]; ix<glklen; ix++, jx+="+refarg.refsize+") {");val=convert_arg(refarg,true,"VM.Read"+refarg.macro+"(jx)");out.push("    "+tmpvar+"[ix] = "+val+";");out.push("  }")}if(arg.retained){if(arraycount==0){out.push("  temp_arg_arrays.length = 0;")}arraycount+=1;out.push("  make_arg_array("+tmpvar+", callargs["+argpos+"], glklen, "+refarg.literal+");")}out.push("}");argpos+=2}else{if((arg instanceof ArgString)||(arg instanceof ArgUnicode)){locals.ix=true;locals.jx=true;var confunc,checkbyte;if(arg instanceof ArgString){checkbyte="0xE0";confunc="byte_array_to_string"}else{checkbyte="0xE2";confunc="uni_array_to_string"}out.push(tmpvar+" = Array();");out.push("jx = callargs["+argpos+"];");out.push("if (VM.ReadByte(jx) != "+checkbyte+') throw("glk '+func.name+': string argument must be unencoded");');out.push("for (jx+="+arg.refsize+"; true; jx+="+arg.refsize+") {");out.push("  ix = VM.Read"+arg.macro+"(jx);");out.push("  if (ix == 0) break;");out.push("  "+tmpvar+".push(ix);");out.push("}");out.push(tmpvar+" = Glk."+confunc+"("+tmpvar+");");argpos+=1}else{throw ("buildfunc: unsupported arg type: "+func.name)}}}}}out.push("if (callargs.length != "+argpos+') throw "glk '+func.name+': wrong number of arguments";');if(retarg||mayblock){locals.glkret=true;retval="glkret = "}else{retval=""}out.push(retval+"Glk.glk_"+func.name+"("+argjoin.join(", ")+");");if(mayblock){out.push("if (glkret === Glk.DidNotReturn) {");out.push("  set_blocked_selector("+func.id+", callargs);");out.push("  return glkret;");out.push("}")}argpos=0;for(ix=0;ix<form.args.length;ix++){arg=form.args[ix];tmpvar="glka"+ix;if((arg instanceof ArgInt)||(arg instanceof ArgChar)||(arg instanceof ArgClass)){argpos+=1}else{if(arg instanceof ArgRef){refarg=arg.arg;if(arg.passout){out.push("if ("+tmpvar+") {");if((refarg instanceof ArgInt)||(refarg instanceof ArgChar)||(refarg instanceof ArgClass)){val=unconvert_arg(refarg,tmpvar+".get_value()");out.push("  VM.WriteWord(callargs["+argpos+"], "+val+");")}else{if(refarg instanceof ArgStruct){subargs=refarg.form.args;for(jx=0;jx<subargs.length;jx++){val=unconvert_arg(subargs[jx],tmpvar+".get_field("+jx+")");out.push("  VM.WriteStructField(callargs["+argpos+"], "+jx+", "+val+");")}}else{throw ("buildfunc: unsupported refarg type: "+func.name)}}out.push("}")}argpos+=1}else{if(arg instanceof ArgArray){refarg=arg.arg;if(arg.passout&&!arg.retained){out.push("if ("+tmpvar+") {");locals.ix=true;locals.jx=true;out.push("  for (ix=0, jx=callargs["+argpos+"]; ix<glklen; ix++, jx+="+refarg.refsize+") {");val=unconvert_arg(refarg,tmpvar+"[ix]");out.push("    VM.Write"+refarg.macro+"(jx, "+val+")");out.push("  }");out.push("}")}argpos+=2}else{if((arg instanceof ArgString)||(arg instanceof ArgUnicode)){argpos+=1}else{throw ("buildfunc: unsupported arg type: "+func.name)}}}}}if(arraycount!=0){out.push("temp_arg_arrays.length = 0;")}if(retarg){val=unconvert_arg(retarg,"glkret");out.push("return "+val+";")}else{out.push("return 0;")}ls=[];for(val in locals){ls.push(val)}if(ls.length){out[0]="var "+ls.join(", ")+";"}val=out.join("\n");eval("function _func(callargs) {\n"+val+"\n}");return _func}var function_map={};function get_function(id){var proto;var func=function_map[id];if(func===undefined){proto=proto_map[id];if(proto===undefined){throw ("dispatch: unknown Glk function: "+id)}func=build_function(proto);function_map[id]=func}return func}var blocked_selector=null;var blocked_callargs=null;function set_blocked_selector(sel,args){blocked_selector=sel;blocked_callargs=args.slice(0)}function prepare_resume(glka0){if(blocked_selector==192){if(blocked_callargs[0]!=0){VM.WriteStructField(blocked_callargs[0],0,glka0.get_field(0)>>>0);VM.WriteStructField(blocked_callargs[0],1,class_obj_to_id("window",glka0.get_field(1)));VM.WriteStructField(blocked_callargs[0],2,glka0.get_field(2)>>>0);VM.WriteStructField(blocked_callargs[0],3,glka0.get_field(3)>>>0)}}else{if(blocked_selector==98){VM.SetResumeStore(class_obj_to_id("fileref",glka0))}}blocked_selector=null;blocked_callargs=null}var temp_arg_arrays=[];var retained_arrays=[];function make_arg_array(arr,addr,len,arg){var obj;if(!arr){return}obj={arr:arr,addr:addr,len:len,arg:arg};temp_arg_arrays.push(obj)}function retain_array(arr){var ix,obj;if(!arr){return}obj=undefined;for(ix=0;ix<temp_arg_arrays.length;ix++){if(temp_arg_arrays[ix].arr===arr){obj=temp_arg_arrays[ix];break}}if(obj===undefined){throw ("retain_array: array is not an argument")}for(ix=0;!(retained_arrays[ix]===undefined);ix++){}retained_arrays[ix]=obj}function unretain_array(arr){var ix,jx,obj;if(!arr){return}obj=undefined;for(ix=0;ix<retained_arrays.length;ix++){if(retained_arrays[ix]===undefined){continue}if(retained_arrays[ix].arr===arr){obj=retained_arrays[ix];delete retained_arrays[ix];break}}if(obj===undefined){throw ("unretain_array: array was never retained")}if(obj.arg instanceof ArgInt){for(ix=0,jx=obj.addr;ix<obj.len;ix++,jx+=4){VM.WriteWord(jx,obj.arr[ix]>>>0)}}else{if(obj.arg instanceof ArgChar){if(!obj.arg.signed){for(ix=0,jx=obj.addr;ix<obj.len;ix++,jx++){VM.WriteByte(jx,obj.arr[ix]&255)}}else{for(ix=0,jx=obj.addr;ix<obj.len;ix++,jx++){VM.WriteByte(jx,uncast_signed_char(obj.arr[ix]))}}}else{throw ("unretain_array: unsupported refarg type")}}}var class_map={};var last_used_id;function class_register(clas,obj){if(obj.disprock){throw ("class_register: object is already registered")}obj.disprock=last_used_id;last_used_id++;class_map[clas][obj.disprock]=obj}function class_unregister(clas,obj){if(!obj.disprock||class_map[clas][obj.disprock]===undefined){throw ("class_unregister: object is not registered")}delete class_map[clas][obj.disprock];obj.disprock=undefined}function init_module(){var ix,key;last_used_id=1+Math.round(Math.random()*1000);for(ix in class_defs){key=class_defs[ix];class_map[key]={}}}init_module();return{set_vm:set_vm,get_function:get_function,prepare_resume:prepare_resume,class_register:class_register,class_unregister:class_unregister,class_obj_to_id:class_obj_to_id,class_obj_from_id:class_obj_from_id,retain_array:retain_array,unretain_array:unretain_array}}();GiLoad=function(){var h={spacing:4,vm:Quixe,io:Glk,use_query_story:true,default_story:null,set_page_title:true,proxy_url:"http://zcode.appspot.com/proxy/"};var j=null;var i={};function d(p,r,w){if(!p){p=window.game_options}if(p){Object.extend(h,p)}j=null;if(h.use_query_story){var l=a();j=l.story}if(!j&&r){GlkOte.log("### trying pre-loaded load ("+w+")...");switch(w){case"base64":r=decode_base64(r);break;case"raw":r=decode_text(r);break;case"array":break;default:h.io.fatal_error("Could not decode story file data: "+w);return}b(r);return}if(!j){j=h.default_story}if(!j){h.io.fatal_error("No story file specified!");return}GlkOte.log("### gameurl: "+j);r=null;w=null;var n=Ajax.getTransport();var s=(n.overrideMimeType!==undefined&&!Prototype.Browser.Opera);var u=(n.withCredentials!==undefined);n=null;var k=/^(file:|(\w+:)?\/\/[^\/?#]+)/;var A=k.exec(location)[0];var t=k.exec(j);var x=t?false:true;var q=t?t[0]:A;var z=(A==q);if(navigator.userAgent.match(/chrome/i)&&q=="file:"){z=false}var B=j.toLowerCase().endsWith(".js");GlkOte.log("### is_relative="+x+", same_origin="+z+", binary_supported="+s+", crossorigin_supported="+u);if(B&&z){GlkOte.log("### trying old-fashioned load...");window.processBase64Zcode=function(C){b(decode_base64(C))};new Ajax.Request(j,{method:"get",evalJS:"force",onFailure:function(C){h.io.fatal_error("The story could not be loaded. ("+j+"): Error "+C.status+": "+C.statusText)}});return}if(B){GlkOte.log("### trying script load...");window.processBase64Zcode=function(C){b(decode_base64(C))};var m=$$("head");if(!m||m.length==0){h.io.fatal_error("This page has no <head> element!");return}var y=new Element("script",{src:j,type:"text/javascript"});m[0].insert(y);return}if(s&&z){GlkOte.log("### trying binary load...");new Ajax.Request(j,{method:"get",onCreate:function(C){C.transport.overrideMimeType("text/plain; charset=x-user-defined")},onSuccess:function(C){b(c(C.responseText))},onFailure:function(C){h.io.fatal_error("The story could not be loaded. ("+j+"): Error "+C.status+": "+C.statusText)}});return}if(q=="file:"){h.io.fatal_error("The story could not be loaded. ("+j+"): A local file cannot be sent to the proxy.");return}var o=j;if(x){o=f(j);GlkOte.log("### absolutize "+j+" to "+o)}if(u){GlkOte.log("### trying proxy load... ("+h.proxy_url+")");new Ajax.Request(h.proxy_url,{method:"get",parameters:{encode:"base64",url:o},onFailure:function(C){h.io.fatal_error("The story could not be loaded. ("+j+"): Error "+C.status+": "+C.statusText)},onSuccess:function(C){b(decode_base64(C.responseText))}});return}if(true){var v=h.proxy_url+"?encode=base64&callback=processBase64Zcode&url="+o;GlkOte.log("### trying proxy-script load... ("+v+")");window.processBase64Zcode=function(C){b(decode_base64(C))};var m=$$("head");if(!m||m.length==0){h.io.fatal_error("This page has no <head> element!");return}var y=new Element("script",{src:v,type:"text/javascript"});m[0].insert(y);return}h.io.fatal_error("The story could not be loaded. ("+j+"): I don't know how to load this data.")}function a(){var p={};var k=location.search.substring(1,location.search.length);if(k.length){var n=k.split("&");k=k.replace(/\+/g," ");for(var l=0;l<n.length;l++){var q=n[l].split("=");var m=decodeURIComponent(q[0]);var o=(q.length==2)?decodeURIComponent(q[1]):m;p[m]=o}}return p}function f(k){var l=new Element("div");l.innerHTML="<a></a>";l.firstChild.href=k;l.innerHTML=l.innerHTML;return l.firstChild.href}function e(m){var r=m.length;var t=12;var v=null;while(t<r){var s=String.fromCharCode(m[t+0],m[t+1],m[t+2],m[t+3]);t+=4;var q=(m[t+0]<<24)|(m[t+1]<<16)|(m[t+2]<<8)|(m[t+3]);t+=4;if(s=="GLUL"){v=m.slice(t,t+q)}if(s=="IFmd"){var o=m.slice(t,t+q);var u=String.fromCharCode.apply(this,o);u=u.replace(/<title>/gi,"<xtitle>");u=u.replace(/<\/title>/gi,"</xtitle>");var p=new Element("metadata").update(u);if(p.down("bibliographic")){var n=p.down("bibliographic").childElements();var k,l;for(l=0;l<n.length;l++){k=n[l];if(k.tagName.toLowerCase()=="xtitle"){i.title=k.textContent}else{i[k.tagName.toLowerCase()]=k.textContent}}}}t+=q;if(t&1){t++}}return v}function c(m){var k=Array(m.length);var l;for(l=0;l<m.length;l++){k[l]=m.charCodeAt(l)&255}return k}if(window.atob){decode_base64=function(l){var m=atob(l);var n=Array(m.length);var k;for(k=0;k<m.length;k++){n[k]=m.charCodeAt(k)}return n}}else{var g=(function(){var m="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";var l=[];var k;for(k=0;k<m.length;k++){l[m.charAt(k)]=k}return l})();decode_base64=function(u){var m=[];var o,l,k,t,s,r,q;var n=0,p=u.length;while(n<p){t=g[u.charAt(n++)];s=g[u.charAt(n++)];r=g[u.charAt(n++)];q=g[u.charAt(n++)];o=(t<<2)+(s>>4);l=((s&15)<<4)+(r>>2);k=((r&3)<<6)+q;m.push(o,l,k)}if(q==64){m.pop()}if(r==64){m.pop()}return m}}function b(l){if(l.length==0){h.io.fatal_error("No game file was loaded. (Zero-length response.)");return}if(l[0]==70&&l[1]==79&&l[2]==82&&l[3]==77){try{l=e(l)}catch(k){h.io.fatal_error("Blorb file could not be parsed: "+k);return}if(!l){h.io.fatal_error("Blorb file contains no Glulx game!");return}}if(h.set_page_title){var m=null;if(i){m=i.title}if(!m&&j){m=j.slice(j.lastIndexOf("/")+1)}if(!m){m="Game"}document.title=m+" - Quixe"}h.vm.prepare(l,h);h.io.init(h)}return{load_run:d}}();